/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.oba.rest.api.resource.PisCancellationApi;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.rest.server.resource.XISControllerService;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import de.adorsys.ledgers.oba.service.api.service.TokenAuthenticationService;
import feign.FeignException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pis-cancellation"})
@Api(value="/pis-cancellation", tags={"PSU PIS Cancellation. Provides access to online banking payment functionality"})
public class PisCancellationController
implements PisCancellationApi {
    private static final Logger log = LoggerFactory.getLogger(PisCancellationController.class);
    private final CommonPaymentService paymentService;
    private final XISControllerService xisService;
    private final HttpServletResponse response;
    private final ResponseUtils responseUtils;
    private final ObaMiddlewareAuthentication middlewareAuth;
    private final AuthRequestInterceptor authInterceptor;
    private final TokenAuthenticationService authenticationService;

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<PaymentAuthorizeResponse> login(String encryptedPaymentId, String authorisationId, String login, String pin, String consentCookieString) {
        String consentCookie = this.responseUtils.consentCookie(consentCookieString);
        PaymentWorkflow workflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, false, consentCookie, null);
        if (workflow.getPaymentStatus().equals(TransactionStatusTO.RCVD.name())) {
            throw ObaException.builder().devMessage(String.format("Cancellation of Payment id: %s is not possible thought OnlineBanking as it's status is RECEIVED, cancellation of this payment is only possible though EMBEDDED route", encryptedPaymentId)).obaErrorCode(ObaErrorCode.LOGIN_FAILED).build();
        }
        this.xisService.checkFailedCount(encryptedPaymentId);
        try {
            GlobalScaResponseTO ledgersResponse = this.authenticationService.login(login, pin, authorisationId);
            workflow.processSCAResponse(ledgersResponse);
            AuthUtils.checkIfUserInitiatedOperation(ledgersResponse, workflow.getPaymentResponse().getPayment().getPsuIdDatas());
            workflow = this.paymentService.initiatePaymentOpr(workflow, login, OpTypeTO.CANCEL_PAYMENT);
        }
        catch (ObaException | FeignException e) {
            this.xisService.resolveFailedLoginAttempt(encryptedPaymentId, workflow.paymentId(), login, workflow.authId(), OpTypeTO.PAYMENT);
        }
        return this.xisService.resolvePaymentWorkflow(workflow);
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndAccessTokenCookieString) {
        return this.xisService.selectScaMethod(encryptedPaymentId, authorisationId, scaMethodId, consentAndAccessTokenCookieString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> authorisePayment(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
            PaymentWorkflow identifyPaymentWorkflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
            PaymentWorkflow authorizeCancelPaymentWorkflow = this.paymentService.authorizePaymentOpr(identifyPaymentWorkflow, psuId, authCode, OpTypeTO.CANCEL_PAYMENT);
            this.responseUtils.setCookies(this.response, authorizeCancelPaymentWorkflow.getConsentReference(), authorizeCancelPaymentWorkflow.bearerToken().getAccess_token(), authorizeCancelPaymentWorkflow.bearerToken().getAccessTokenObject());
            log.info("Confirmation code: {}", (Object)authorizeCancelPaymentWorkflow.getAuthResponse().getAuthConfirmationCode());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authorizeCancelPaymentWorkflow.getAuthResponse());
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> pisDone(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, boolean isOauth2Integrated, String authConfirmationCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
        String redirectUrl = this.paymentService.resolveRedirectUrl(encryptedPaymentId, authorisationId, consentCookie, isOauth2Integrated, psuId, this.middlewareAuth.getBearerToken(), authConfirmationCode);
        return this.responseUtils.redirect(redirectUrl, this.response);
    }

    public PisCancellationController(CommonPaymentService paymentService, XISControllerService xisService, HttpServletResponse response, ResponseUtils responseUtils, ObaMiddlewareAuthentication middlewareAuth, AuthRequestInterceptor authInterceptor, TokenAuthenticationService authenticationService) {
        this.paymentService = paymentService;
        this.xisService = xisService;
        this.response = response;
        this.responseUtils = responseUtils;
        this.middlewareAuth = middlewareAuth;
        this.authInterceptor = authInterceptor;
        this.authenticationService = authenticationService;
    }
}

