/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.oba.rest.api.resource.PISApi;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.rest.server.resource.XISControllerService;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentType;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import de.adorsys.ledgers.oba.service.api.service.TokenAuthenticationService;
import feign.FeignException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pis"})
@Api(value="/pis", tags={"PSU PIS. Provides access to online banking payment functionality"})
public class PISController
implements PISApi {
    private static final Logger log = LoggerFactory.getLogger(PISController.class);
    private final CommonPaymentService paymentService;
    private final XISControllerService xisService;
    private final HttpServletResponse response;
    private final ResponseUtils responseUtils;
    private final ObaMiddlewareAuthentication middlewareAuth;
    private final AuthRequestInterceptor authInterceptor;
    private final TokenAuthenticationService authenticationService;

    public ResponseEntity<AuthorizeResponse> pisAuth(String redirectId, String encryptedPaymentId, String token) {
        return this.xisService.auth(redirectId, ConsentType.PIS, encryptedPaymentId, this.response);
    }

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<PaymentAuthorizeResponse> login(String encryptedPaymentId, String authorisationId, String login, String pin, String consentCookieString) {
        String consentCookie = this.responseUtils.consentCookie(consentCookieString);
        PaymentWorkflow workflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, false, consentCookie, null);
        this.xisService.checkFailedCount(encryptedPaymentId);
        try {
            GlobalScaResponseTO ledgersResponse = this.authenticationService.login(login, pin, authorisationId);
            workflow.processSCAResponse(ledgersResponse);
            AuthUtils.checkIfUserInitiatedOperation(ledgersResponse, workflow.getPaymentResponse().getPayment().getPsuIdDatas());
        }
        catch (ObaException | FeignException e) {
            this.xisService.resolveFailedLoginAttempt(encryptedPaymentId, workflow.paymentId(), login, workflow.authId(), OpTypeTO.PAYMENT);
        }
        workflow = this.paymentService.initiatePaymentOpr(workflow, workflow.bearerToken().getAccessTokenObject().getLogin(), OpTypeTO.PAYMENT);
        return this.xisService.resolvePaymentWorkflow(workflow);
    }

    public ResponseEntity<PaymentAuthorizeResponse> initiatePayment(String encryptedPaymentId, String authorisationId, String consentAndaccessTokenCookieString) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        String consentCookie = this.responseUtils.consentCookie(consentAndaccessTokenCookieString);
        PaymentWorkflow identifyPaymentWorkflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
        identifyPaymentWorkflow.getScaResponse().setScaStatus(ScaStatusTO.PSUAUTHENTICATED);
        PaymentWorkflow initiatePaymentWorkflow = this.paymentService.initiatePaymentOpr(identifyPaymentWorkflow, psuId, OpTypeTO.PAYMENT);
        this.responseUtils.setCookies(this.response, initiatePaymentWorkflow.getConsentReference(), initiatePaymentWorkflow.bearerToken().getAccess_token(), initiatePaymentWorkflow.bearerToken().getAccessTokenObject());
        return ResponseEntity.ok((Object)initiatePaymentWorkflow.getAuthResponse());
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndaccessTokenCookieString) {
        return this.xisService.selectScaMethod(encryptedPaymentId, authorisationId, scaMethodId, consentAndaccessTokenCookieString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> authrizedPayment(String encryptedPaymentId, String authorisationId, String consentAndaccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndaccessTokenCookieString);
            PaymentWorkflow identifyPaymentWorkflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
            PaymentWorkflow authorizePaymentWorkflow = this.paymentService.authorizePaymentOpr(identifyPaymentWorkflow, psuId, authCode, OpTypeTO.PAYMENT);
            this.responseUtils.setCookies(this.response, authorizePaymentWorkflow.getConsentReference(), authorizePaymentWorkflow.bearerToken().getAccess_token(), authorizePaymentWorkflow.bearerToken().getAccessTokenObject());
            log.info("Confirmation code: {}", (Object)authorizePaymentWorkflow.getAuthResponse().getAuthConfirmationCode());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authorizePaymentWorkflow.getAuthResponse());
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> failPaymentAuthorisation(String encryptedPaymentId, String authorisationId, String cookieString) {
        try {
            String consentCookie = this.responseUtils.consentCookie(cookieString);
            PaymentWorkflow workflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            workflow.getScaResponse().setScaStatus(ScaStatusTO.FAILED);
            this.paymentService.updateAspspConsentData(workflow);
            this.responseUtils.removeCookies(this.response);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)workflow.getAuthResponse());
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> pisDone(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, boolean isOauth2Integrated, String authConfirmationCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
        String redirectUrl = this.paymentService.resolveRedirectUrl(encryptedPaymentId, authorisationId, consentCookie, isOauth2Integrated, psuId, this.middlewareAuth.getBearerToken(), authConfirmationCode);
        return this.responseUtils.redirect(redirectUrl, this.response);
    }

    public PISController(CommonPaymentService paymentService, XISControllerService xisService, HttpServletResponse response, ResponseUtils responseUtils, ObaMiddlewareAuthentication middlewareAuth, AuthRequestInterceptor authInterceptor, TokenAuthenticationService authenticationService) {
        this.paymentService = paymentService;
        this.xisService = xisService;
        this.response = response;
        this.responseUtils = responseUtils;
        this.middlewareAuth = middlewareAuth;
        this.authInterceptor = authInterceptor;
        this.authenticationService = authenticationService;
    }
}

