/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.auth;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.service.api.domain.UserAuthentication;
import de.adorsys.ledgers.oba.service.api.service.TokenAuthenticationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.WebUtils;

public class JWTAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private static final List<String> EXCLUDED_URLS = Arrays.asList("/**/auth", "/**/login");
    private static final AntPathMatcher matcher = new AntPathMatcher();
    private static final String ACCESS_TOKEN_COOKIE = "ACCESS_TOKEN";
    private final TokenAuthenticationService tokenAuthenticationService;
    private final AuthRequestInterceptor authInterceptor;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String tokenCookie;
        UserAuthentication userAuthentication;
        if (log.isTraceEnabled()) {
            log.trace("doFilter start");
        }
        this.authInterceptor.setAccessToken(null);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null && (userAuthentication = this.tokenAuthenticationService.getAuthentication(StringUtils.isBlank((CharSequence)(tokenCookie = this.readAccessTokenCookie(request))) ? this.readAccessTokenHeader(request) : tokenCookie)) != null) {
            BearerTokenTO bearerToken = userAuthentication.getBearerToken();
            AccessTokenTO token = bearerToken.getAccessTokenObject();
            SecurityContextHolder.getContext().setAuthentication((Authentication)new ObaMiddlewareAuthentication(token.getSub(), bearerToken, this.buildAuthorities(token)));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (log.isTraceEnabled()) {
            log.trace("doFilter end");
        }
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        return EXCLUDED_URLS.stream().anyMatch(p -> matcher.match(p, request.getServletPath()));
    }

    private String readAccessTokenCookie(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)ACCESS_TOKEN_COOKIE);
        return cookie != null ? cookie.getValue() : null;
    }

    private String readAccessTokenHeader(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("authorization")).map(s -> s.replace("Bearer ", "")).orElse(null);
    }

    private List<GrantedAuthority> buildAuthorities(AccessTokenTO token) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (token.getRole() != null) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + token.getRole().name()));
        }
        return authorities;
    }

    public JWTAuthenticationFilter(TokenAuthenticationService tokenAuthenticationService, AuthRequestInterceptor authInterceptor) {
        this.tokenAuthenticationService = tokenAuthenticationService;
        this.authInterceptor = authInterceptor;
    }
}

