/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.oba.rest.api.resource.exception.PaymentAuthorizeException;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.ConsentType;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.InvalidConsentException;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class XISControllerService {
    private static final Logger log = LoggerFactory.getLogger(XISControllerService.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ConsentReferencePolicy referencePolicy;
    private final ResponseUtils responseUtils;
    private final KeycloakTokenService tokenService;
    private final CommonPaymentService paymentService;
    private final ObaMiddlewareAuthentication middlewareAuth;
    @Value(value="${online-banking.sca.loginpage:http://localhost:4400/}")
    private String loginPage;

    public ResponseEntity<AuthorizeResponse> auth(String redirectId, ConsentType consentType, String encryptedConsentId, HttpServletResponse response) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        try {
            ConsentReference consentReference = this.referencePolicy.fromURL(redirectId, consentType, encryptedConsentId);
            authResponse.setEncryptedConsentId(encryptedConsentId);
            authResponse.setAuthorisationId(redirectId);
            String token = Optional.ofNullable(this.request.getHeader("Authorization")).filter(t -> StringUtils.startsWithIgnoreCase((CharSequence)t, (CharSequence)"Bearer ")).map(t -> StringUtils.substringAfter((String)t, (String)"Bearer ")).orElse(null);
            AccessTokenTO tokenTO = Optional.ofNullable(token).map(arg_0 -> ((KeycloakTokenService)this.tokenService).validate(arg_0)).map(BearerTokenTO::getAccessTokenObject).orElse(null);
            this.responseUtils.setCookies(response, consentReference, token, tokenTO);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                response.addHeader("Authorization", token);
            }
        }
        catch (InvalidConsentException e) {
            log.info(e.getMessage());
            this.responseUtils.removeCookies(response);
            return this.responseUtils.unknownCredentials(authResponse, response);
        }
        String uriString = UriComponentsBuilder.fromUriString((String)this.loginPage).queryParam("encryptedConsentId", new Object[]{authResponse.getEncryptedConsentId()}).queryParam("authorisationId", new Object[]{authResponse.getAuthorisationId()}).build().toUriString();
        response.addHeader("Location", uriString);
        return ResponseEntity.ok((Object)authResponse);
    }

    public ResponseEntity<PaymentAuthorizeResponse> resolvePaymentWorkflow(PaymentWorkflow workflow) {
        ScaStatusTO scaStatusTO = workflow.scaStatus();
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.FINALISED, ScaStatusTO.EXEMPTED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.SCAMETHODSELECTED).contains(scaStatusTO)) {
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectScaMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndaccessTokenCookieString) {
        PaymentWorkflow workflow;
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndaccessTokenCookieString);
            workflow = this.paymentService.selectScaForPayment(encryptedPaymentId, authorisationId, scaMethodId, consentCookie, AuthUtils.psuId(this.middlewareAuth), this.middlewareAuth.getBearerToken());
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
        }
        catch (PaymentAuthorizeException p) {
            return p.getError();
        }
        return ResponseEntity.ok((Object)workflow.getAuthResponse());
    }

    public XISControllerService(HttpServletRequest request, HttpServletResponse response, ConsentReferencePolicy referencePolicy, ResponseUtils responseUtils, KeycloakTokenService tokenService, CommonPaymentService paymentService, ObaMiddlewareAuthentication middlewareAuth) {
        this.request = request;
        this.response = response;
        this.referencePolicy = referencePolicy;
        this.responseUtils = responseUtils;
        this.tokenService = tokenService;
        this.paymentService = paymentService;
        this.middlewareAuth = middlewareAuth;
    }
}

