/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.api.resource.SCAApi;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PsuMessage;
import de.adorsys.ledgers.oba.service.api.domain.PsuMessageCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sca"})
@Api(value="/sca", tags={"PSU SCA. Provides access to one time password for strong customer authentication."})
public class SCAController
implements SCAApi {
    private final UserMgmtRestClient ledgersUserMgmt;
    private final ResponseUtils responseUtils;
    private final AuthRequestInterceptor authInterceptor;
    private final HttpServletResponse response;
    private final ObaMiddlewareAuthentication auth;

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<AuthorizeResponse> login(String login, String pin) {
        SCALoginResponseTO loginResponse = new SCALoginResponseTO();
        AuthorizeResponse authResponse = new AuthorizeResponse();
        ScaStatusTO scaStatus = this.prepareAuthResponse(authResponse, Objects.requireNonNull(loginResponse));
        BearerTokenTO bearerToken = loginResponse.getBearerToken();
        switch (scaStatus) {
            case PSUIDENTIFIED: {
                authResponse.setScaMethods(loginResponse.getScaMethods());
            }
            case FINALISED: 
            case EXEMPTED: 
            case PSUAUTHENTICATED: 
            case SCAMETHODSELECTED: {
                this.responseUtils.setCookies(this.response, null, bearerToken.getAccess_token(), bearerToken.getAccessTokenObject());
                return ResponseEntity.ok((Object)authResponse);
            }
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    private ScaStatusTO prepareAuthResponse(AuthorizeResponse authResponse, SCALoginResponseTO loginResponse) {
        ScaStatusTO scaStatus = loginResponse.getScaStatus();
        authResponse.setScaStatus(scaStatus);
        authResponse.setAuthorisationId(loginResponse.getBearerToken().getAccessTokenObject().getAuthorisationId());
        PsuMessage psuMessage = new PsuMessage().category(PsuMessageCategory.INFO).text(loginResponse.getPsuMessage());
        authResponse.setPsuMessages(Collections.singletonList(psuMessage));
        return scaStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<AuthorizeResponse> selectMethod(String scaId, String authorisationId, String methodId, String cookies) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        authResponse.setEncryptedConsentId(scaId);
        authResponse.setAuthorisationId(authorisationId);
        try {
            this.authInterceptor.setAccessToken(this.auth.getBearerToken().getAccess_token());
            SCALoginResponseTO loginResponse = new SCALoginResponseTO();
            this.prepareAuthResponse(authResponse, Objects.requireNonNull(loginResponse));
            BearerTokenTO bearerToken = loginResponse.getBearerToken();
            this.responseUtils.setCookies(this.response, null, bearerToken.getAccess_token(), bearerToken.getAccessTokenObject());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authResponse);
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<AuthorizeResponse> validateAuthCode(String scaId, String authorisationId, String authCode, String cookies) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        authResponse.setEncryptedConsentId(scaId);
        authResponse.setAuthorisationId(authorisationId);
        try {
            this.authInterceptor.setAccessToken(this.auth.getBearerToken().getAccess_token());
            SCALoginResponseTO authorizeResponse = new SCALoginResponseTO();
            this.prepareAuthResponse(authResponse, Objects.requireNonNull(authorizeResponse));
            BearerTokenTO bearerToken = authorizeResponse.getBearerToken();
            this.responseUtils.setCookies(this.response, null, bearerToken.getAccess_token(), bearerToken.getAccessTokenObject());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authResponse);
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public SCAController(UserMgmtRestClient ledgersUserMgmt, ResponseUtils responseUtils, AuthRequestInterceptor authInterceptor, HttpServletResponse response, ObaMiddlewareAuthentication auth) {
        this.ledgersUserMgmt = ledgersUserMgmt;
        this.responseUtils = responseUtils;
        this.authInterceptor = authInterceptor;
        this.response = response;
        this.auth = auth;
    }
}

