/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AccountRestClient;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.ConsentRestClient;
import de.adorsys.ledgers.middleware.client.rest.OauthRestClient;
import de.adorsys.ledgers.oba.rest.api.resource.AISApi;
import de.adorsys.ledgers.oba.rest.api.resource.exception.ConsentAuthorizeException;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.rest.server.resource.XISControllerService;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentType;
import de.adorsys.ledgers.oba.service.api.domain.ConsentWorkflow;
import de.adorsys.ledgers.oba.service.api.service.AuthorizationService;
import de.adorsys.ledgers.oba.service.api.service.RedirectConsentService;
import de.adorsys.psd2.consent.api.ais.AisAccountConsentAuthorisation;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuAisClient;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ais"})
@Api(value="/ais", tags={"PSU AIS. Provides access to online banking account functionality"})
public class AISController
implements AISApi {
    private static final Logger log = LoggerFactory.getLogger(AISController.class);
    private final CmsPsuAisClient cmsPsuAisClient;
    private final ConsentRestClient consentRestClient;
    private final AccountRestClient accountRestClient;
    private final OauthRestClient oauthRestClient;
    private final RedirectConsentService redirectConsentService;
    private final XISControllerService xisService;
    private final HttpServletResponse response;
    private final ResponseUtils responseUtils;
    private final ObaMiddlewareAuthentication middlewareAuth;
    private final AuthRequestInterceptor authInterceptor;
    private final AuthorizationService authService;

    @ApiOperation(value="Entry point for authenticating ais consent requests.")
    public ResponseEntity<AuthorizeResponse> aisAuth(String redirectId, String encryptedConsentId, String token) {
        return this.xisService.auth(redirectId, ConsentType.AIS, encryptedConsentId, this.response);
    }

    public ResponseEntity<ConsentAuthorizeResponse> login(String encryptedConsentId, String authorisationId, String login, String pin, String consentCookieString) {
        ConsentWorkflow workflow;
        try {
            String consentCookie = this.responseUtils.consentCookie(consentCookieString);
            workflow = this.redirectConsentService.identifyConsent(encryptedConsentId, authorisationId, false, consentCookie, null);
        }
        catch (ConsentAuthorizeException e) {
            return e.getError();
        }
        ResponseEntity<SCALoginResponseTO> loginResult = this.xisService.performLoginForConsent(login, pin, workflow.consentId(), workflow.authId(), OpTypeTO.CONSENT);
        AuthUtils.checkIfUserInitiatedOperation(loginResult, workflow.getConsentResponse().getAccountConsent().getPsuIdDataList());
        workflow.storeSCAResponse((SCAResponseTO)loginResult.getBody());
        if (AuthUtils.success(loginResult)) {
            String psuId = AuthUtils.psuId(workflow.bearerToken());
            try {
                this.updatePSUIdentification(workflow, psuId);
                this.redirectConsentService.updateScaStatusConsentStatusConsentData(psuId, workflow);
            }
            catch (ConsentAuthorizeException e) {
                return e.getError();
            }
            return this.resolveResponseByScaStatus(workflow, true);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    public ResponseEntity<ConsentAuthorizeResponse> startConsentAuth(String encryptedConsentId, String authorisationId, String consentAndAccessTokenCookieString, AisConsentTO aisConsent) {
        ConsentWorkflow workflow;
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
            workflow = this.redirectConsentService.identifyConsent(encryptedConsentId, authorisationId, false, consentCookie, this.middlewareAuth.getBearerToken());
            List<AccountDetailsTO> listOfAccounts = this.listOfAccounts(workflow);
            this.redirectConsentService.startConsent(workflow, aisConsent, listOfAccounts);
            this.redirectConsentService.updateScaStatusConsentStatusConsentData(psuId, workflow);
        }
        catch (ConsentAuthorizeException e) {
            return e.getError();
        }
        return this.resolveResponseByScaStatus(workflow, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<ConsentAuthorizeResponse> authrizedConsent(String encryptedConsentId, String authorisationId, String consentAndAccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
            ConsentWorkflow workflow = this.redirectConsentService.identifyConsent(encryptedConsentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            SCAConsentResponseTO scaConsentResponse = (SCAConsentResponseTO)this.consentRestClient.authorizeConsent(workflow.consentId(), authorisationId, authCode).getBody();
            workflow.storeSCAResponse((SCAResponseTO)scaConsentResponse);
            if (scaConsentResponse != null && ScaStatusTO.FINALISED == scaConsentResponse.getScaStatus()) {
                this.cmsPsuAisClient.confirmConsent(workflow.consentId(), psuId, null, null, null, "UNDEFINED");
            }
            this.redirectConsentService.updateScaStatusConsentStatusConsentData(psuId, workflow);
            Optional<BearerTokenTO> token = Optional.ofNullable(workflow.bearerToken());
            String tokenString = token.map(BearerTokenTO::getAccess_token).orElseGet(() -> "");
            AccessTokenTO tokenTO = token.map(BearerTokenTO::getAccessTokenObject).orElse(null);
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), tokenString, tokenTO);
            log.info("Confirmation code: {}", (Object)workflow.getAuthResponse().getAuthConfirmationCode());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)workflow.getAuthResponse());
            return responseEntity;
        }
        catch (ConsentAuthorizeException e) {
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<ConsentAuthorizeResponse> selectMethod(String encryptedConsentId, String authorisationId, String scaMethodId, String consentAndAccessTokenCookieString) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
            ConsentWorkflow workflow = this.redirectConsentService.identifyConsent(encryptedConsentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
            this.redirectConsentService.selectScaMethod(scaMethodId, workflow);
            this.redirectConsentService.updateScaStatusConsentStatusConsentData(psuId, workflow);
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        catch (ConsentAuthorizeException e) {
            return e.getError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts(String accessTokenCookieString) {
        try {
            this.authInterceptor.setAccessToken(this.middlewareAuth.getBearerToken().getAccess_token());
            ResponseEntity listOfAccounts = this.accountRestClient.getListOfAccounts();
            ResponseEntity responseEntity = ResponseEntity.ok((Object)((List)listOfAccounts.getBody()));
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<ConsentAuthorizeResponse> aisDone(String encryptedConsentId, String authorisationId, String cookie, boolean isOauth2Integrated, String authConfirmationCode) {
        String consentCookie = this.responseUtils.consentCookie(cookie);
        ConsentWorkflow workflow = this.redirectConsentService.identifyConsent(encryptedConsentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
        ConsentStatus consentStatus = workflow.getConsentResponse().getAccountConsent().getConsentStatus();
        CmsAisConsentResponse consentResponse = workflow.getConsentResponse();
        this.authInterceptor.setAccessToken(workflow.getScaResponse().getBearerToken().getAccess_token());
        String tppOkRedirectUri = isOauth2Integrated ? ((OauthCodeResponseTO)this.oauthRestClient.oauthCode(consentResponse.getTppOkRedirectUri()).getBody()).getRedirectUri() : this.authService.resolveAuthConfirmationCodeRedirectUri(consentResponse.getTppOkRedirectUri(), authConfirmationCode);
        String tppNokRedirectUri = Optional.ofNullable(consentResponse.getTppNokRedirectUri()).filter(StringUtils::isNotBlank).orElse(consentResponse.getTppOkRedirectUri());
        String redirectURL = EnumSet.of(ConsentStatus.VALID, ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED).contains(consentStatus) && this.isNotFailedAuthorizationList(consentResponse) ? tppOkRedirectUri : tppNokRedirectUri;
        return this.responseUtils.redirect(redirectURL, this.response);
    }

    private boolean isNotFailedAuthorizationList(CmsAisConsentResponse consentResponse) {
        return consentResponse.getAccountConsent().getAccountConsentAuthorizations().stream().map(AisAccountConsentAuthorisation::getScaStatus).anyMatch(s -> s != ScaStatus.FAILED);
    }

    public ResponseEntity<ConsentAuthorizeResponse> revokeConsent(@NotNull String encryptedConsentId, @NotNull String authorisationId, String cookieString) {
        ConsentWorkflow workflow;
        try {
            String consentCookie = this.responseUtils.consentCookie(cookieString);
            workflow = this.redirectConsentService.identifyConsent(encryptedConsentId, authorisationId, true, consentCookie, this.middlewareAuth.getBearerToken());
            this.authInterceptor.setAccessToken(this.middlewareAuth.getBearerToken().getAccess_token());
        }
        catch (ConsentAuthorizeException e) {
            return ResponseEntity.badRequest().build();
        }
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        if (this.failAuthorisation(workflow.consentId(), psuId, authorisationId)) {
            return ResponseEntity.ok((Object)this.buildResponseForSuccessfulConsentRevoke());
        }
        return ResponseEntity.badRequest().build();
    }

    private ResponseEntity<ConsentAuthorizeResponse> resolveResponseByScaStatus(ConsentWorkflow workflow, boolean isLoginOperation) {
        ScaStatusTO scaStatusTO = workflow.scaStatus();
        if (scaStatusTO == ScaStatusTO.EXEMPTED) {
            this.responseUtils.removeCookies(this.response);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
        }
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.FINALISED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.SCAMETHODSELECTED).contains(scaStatusTO)) {
            List<AccountDetailsTO> listOfAccounts = this.listOfAccounts(workflow);
            workflow.getAuthResponse().setAccounts(listOfAccounts);
            if (isLoginOperation) {
                this.redirectConsentService.updateAccessByConsentType(workflow, listOfAccounts);
            }
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    private boolean failAuthorisation(String consentId, String psuId, String authorisationId) {
        ResponseEntity updateAuthorisationStatusResponse = this.cmsPsuAisClient.updateAuthorisationStatus(consentId, "FAILED", authorisationId, psuId, null, null, null, "UNDEFINED", new AuthenticationDataHolder(null, null));
        return updateAuthorisationStatusResponse.getStatusCode() == HttpStatus.OK;
    }

    private ConsentAuthorizeResponse buildResponseForSuccessfulConsentRevoke() {
        ConsentAuthorizeResponse consentAuthorisationResponse = new ConsentAuthorizeResponse();
        consentAuthorisationResponse.setScaStatus(ScaStatusTO.EXEMPTED);
        consentAuthorisationResponse.setAccounts(Collections.emptyList());
        AisConsentTO consent = new AisConsentTO();
        AisAccountAccessInfoTO access = new AisAccountAccessInfoTO();
        access.setBalances(Collections.emptyList());
        access.setAccounts(Collections.emptyList());
        access.setTransactions(Collections.emptyList());
        consent.setAccess(access);
        consentAuthorisationResponse.setConsent(consent);
        return consentAuthorisationResponse;
    }

    private void updatePSUIdentification(ConsentWorkflow workflow, String psuId) {
        PsuIdData psuIdData = new PsuIdData(psuId, null, null, null, null);
        ResponseEntity resp = this.cmsPsuAisClient.updatePsuDataInConsent(workflow.consentId(), workflow.authId(), "UNDEFINED", psuIdData);
        if (!HttpStatus.OK.equals((Object)resp.getStatusCode())) {
            throw new ConsentAuthorizeException(this.responseUtils.couldNotProcessRequest(new ConsentAuthorizeResponse(), "Error updating psu identification. See error code.", resp.getStatusCode(), this.response));
        }
    }

    private List<AccountDetailsTO> listOfAccounts(ConsentWorkflow workflow) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            List list = (List)this.accountRestClient.getListOfAccounts().getBody();
            return list;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public AISController(CmsPsuAisClient cmsPsuAisClient, ConsentRestClient consentRestClient, AccountRestClient accountRestClient, OauthRestClient oauthRestClient, RedirectConsentService redirectConsentService, XISControllerService xisService, HttpServletResponse response, ResponseUtils responseUtils, ObaMiddlewareAuthentication middlewareAuth, AuthRequestInterceptor authInterceptor, AuthorizationService authService) {
        this.cmsPsuAisClient = cmsPsuAisClient;
        this.consentRestClient = consentRestClient;
        this.accountRestClient = accountRestClient;
        this.oauthRestClient = oauthRestClient;
        this.redirectConsentService = redirectConsentService;
        this.xisService = xisService;
        this.response = response;
        this.responseUtils = responseUtils;
        this.middlewareAuth = middlewareAuth;
        this.authInterceptor = authInterceptor;
        this.authService = authService;
    }
}

