/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.oba.rest.api.resource.PisCancellationApi;
import de.adorsys.ledgers.oba.rest.api.resource.exception.PaymentAuthorizeException;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.rest.server.resource.XISControllerService;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthorizationException;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pis-cancellation"})
@Api(value="/pis-cancellation", tags={"PSU PIS Cancellation. Provides access to online banking payment functionality"})
public class PisCancellationController
implements PisCancellationApi {
    private static final Logger log = LoggerFactory.getLogger(PisCancellationController.class);
    private final CommonPaymentService paymentService;
    private final XISControllerService xisService;
    private final HttpServletResponse response;
    private final ResponseUtils responseUtils;
    private final ObaMiddlewareAuthentication middlewareAuth;
    private final AuthRequestInterceptor authInterceptor;

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<PaymentAuthorizeResponse> login(String encryptedPaymentId, String authorisationId, String login, String pin, String consentCookieString) {
        String consentCookie = this.responseUtils.consentCookie(consentCookieString);
        PaymentWorkflow cancellationWorkflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, false, consentCookie, login, null);
        if (cancellationWorkflow.getPaymentStatus().equals(TransactionStatusTO.RCVD.name())) {
            throw AuthorizationException.builder().devMessage(String.format("Cancellation of Payment id: %s is not possible thought OnlineBanking as it's status is RECEIVED, cancellation of this payment is only possible though EMBEDDED route", encryptedPaymentId)).errorCode(AuthErrorCode.LOGIN_FAILED).build();
        }
        ResponseEntity<SCALoginResponseTO> loginResult = this.xisService.performLoginForConsent(login, pin, cancellationWorkflow.paymentId(), cancellationWorkflow.authId(), OpTypeTO.CANCEL_PAYMENT);
        AuthUtils.checkIfUserInitiatedOperation(loginResult, cancellationWorkflow.getPaymentResponse().getPayment().getPsuIdDatas());
        cancellationWorkflow.processSCAResponse((SCAResponseTO)Objects.requireNonNull((SCALoginResponseTO)loginResult.getBody()));
        if (!AuthUtils.success(loginResult)) {
            this.responseUtils.removeCookies(this.response);
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        String psuId = AuthUtils.psuId(cancellationWorkflow.bearerToken());
        PaymentWorkflow initiateCancelPaymentWorkflow = this.paymentService.initiateCancelPayment(cancellationWorkflow, psuId);
        return this.xisService.resolvePaymentWorkflow(initiateCancelPaymentWorkflow);
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndAccessTokenCookieString) {
        PaymentWorkflow workflow;
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
            workflow = this.paymentService.selectScaForPayment(encryptedPaymentId, authorisationId, scaMethodId, consentCookie, true, AuthUtils.psuId(this.middlewareAuth), this.middlewareAuth.getBearerToken());
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
        }
        catch (PaymentAuthorizeException p) {
            return p.getError();
        }
        return ResponseEntity.ok((Object)workflow.getAuthResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> authorisePayment(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
            PaymentWorkflow identifyPaymentWorkflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, psuId, this.middlewareAuth.getBearerToken());
            PaymentWorkflow authorizeCancelPaymentWorkflow = this.paymentService.authorizeCancelPayment(identifyPaymentWorkflow, psuId, authCode);
            this.responseUtils.setCookies(this.response, authorizeCancelPaymentWorkflow.getConsentReference(), authorizeCancelPaymentWorkflow.bearerToken().getAccess_token(), authorizeCancelPaymentWorkflow.bearerToken().getAccessTokenObject());
            log.info("Confirmation code: {}", (Object)authorizeCancelPaymentWorkflow.getAuthResponse().getAuthConfirmationCode());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authorizeCancelPaymentWorkflow.getAuthResponse());
            return responseEntity;
        }
        catch (PaymentAuthorizeException e) {
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> pisDone(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, boolean isOauth2Integrated, String authConfirmationCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
        String redirectUrl = this.paymentService.resolveRedirectUrl(encryptedPaymentId, authorisationId, consentCookie, isOauth2Integrated, psuId, this.middlewareAuth.getBearerToken(), authConfirmationCode);
        return this.responseUtils.redirect(redirectUrl, this.response);
    }

    public PisCancellationController(CommonPaymentService paymentService, XISControllerService xisService, HttpServletResponse response, ResponseUtils responseUtils, ObaMiddlewareAuthentication middlewareAuth, AuthRequestInterceptor authInterceptor) {
        this.paymentService = paymentService;
        this.xisService = xisService;
        this.response = response;
        this.responseUtils = responseUtils;
        this.middlewareAuth = middlewareAuth;
        this.authInterceptor = authInterceptor;
    }
}

