/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.oba.rest.server.config.cors.CookieConfigProperties;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.OnlineBankingResponse;
import de.adorsys.ledgers.oba.service.api.domain.PsuMessage;
import de.adorsys.ledgers.oba.service.api.domain.PsuMessageCategory;
import java.net.HttpCookie;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class ResponseUtils {
    private static final String LOCATION_HEADER_NAME = "Location";
    public static final String CONSENT_COOKIE_NAME = "CONSENT";
    public static final String ACCESS_TOKEN_COOKIE_NAME = "ACCESS_TOKEN";
    public static final String UNKNOWN_CREDENTIALS = "Unknown credentials";
    private final CookieConfigProperties cookieConfigProperties;

    public void setCookies(HttpServletResponse response, ConsentReference consentReference, String accessTokenString, AccessTokenTO accessTokenTO) {
        int validity = this.cookieConfigProperties.getMaxAge();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessTokenString}) && accessTokenTO != null) {
            long diffInMillies = Math.abs(new Date().getTime() - accessTokenTO.getExp().getTime());
            validity = Long.valueOf(TimeUnit.SECONDS.convert(diffInMillies, TimeUnit.MILLISECONDS)).intValue();
            Cookie accessTokenCookie = new Cookie(ACCESS_TOKEN_COOKIE_NAME, accessTokenString);
            accessTokenCookie.setHttpOnly(this.cookieConfigProperties.isHttpOnly());
            accessTokenCookie.setSecure(this.cookieConfigProperties.isSecure());
            accessTokenCookie.setMaxAge(validity);
            accessTokenCookie.setPath(this.cookieConfigProperties.getPath());
            response.addCookie(accessTokenCookie);
        } else {
            this.removeCookie(response, ACCESS_TOKEN_COOKIE_NAME);
        }
        if (consentReference != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consentReference.getCookieString()})) {
            Cookie consentCookie = new Cookie(CONSENT_COOKIE_NAME, consentReference.getCookieString());
            consentCookie.setHttpOnly(true);
            consentCookie.setSecure(this.cookieConfigProperties.isSecure());
            consentCookie.setMaxAge(validity);
            consentCookie.setPath(this.cookieConfigProperties.getPath());
            response.addCookie(consentCookie);
        }
    }

    public void removeCookies(HttpServletResponse response) {
        this.removeCookie(response, ACCESS_TOKEN_COOKIE_NAME);
        this.removeCookie(response, CONSENT_COOKIE_NAME);
    }

    private void removeCookie(HttpServletResponse response, String cookieName) {
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setHttpOnly(this.cookieConfigProperties.isHttpOnly());
        cookie.setSecure(this.cookieConfigProperties.isSecure());
        cookie.setPath(this.cookieConfigProperties.getPath());
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public <T extends OnlineBankingResponse> ResponseEntity<T> unknownCredentials(T resp, HttpServletResponse httpResp) {
        return this.error(resp, HttpStatus.FORBIDDEN, UNKNOWN_CREDENTIALS, httpResp);
    }

    public <T extends OnlineBankingResponse> ResponseEntity<T> couldNotProcessRequest(T authResp, String message, HttpStatus status, HttpServletResponse httpResp) {
        return this.error(authResp, status, message, httpResp);
    }

    public <T extends OnlineBankingResponse> ResponseEntity<T> redirect(String locationURI, HttpServletResponse httpResp) {
        HttpHeaders headers = new HttpHeaders();
        if (!UrlUtils.isAbsoluteUrl((String)locationURI)) {
            locationURI = "http://" + (String)locationURI;
        }
        headers.add(LOCATION_HEADER_NAME, (String)locationURI);
        this.removeCookies(httpResp);
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.FOUND);
    }

    public <T extends OnlineBankingResponse> ResponseEntity<T> error(T authResp, HttpStatus status, String message, HttpServletResponse response) {
        PsuMessage psuMessage = new PsuMessage();
        psuMessage.setCategory(PsuMessageCategory.ERROR);
        psuMessage.setText(message);
        psuMessage.setCode(status.toString());
        authResp.getPsuMessages().add(psuMessage);
        this.removeCookies(response);
        return ResponseEntity.status((HttpStatus)status).body(authResp);
    }

    public String consentCookie(String cookieString) {
        return this.cookie(cookieString, CONSENT_COOKIE_NAME);
    }

    private String cookie(String cookieStringIn, String name) {
        String cookieString = cookieStringIn;
        if (cookieString == null) {
            return null;
        }
        String cookieParamName = name + "=";
        if (!StringUtils.startsWithIgnoreCase((CharSequence)cookieString, (CharSequence)cookieParamName)) {
            int indexOfIgnoreCase = StringUtils.indexOfIgnoreCase((CharSequence)cookieString, (CharSequence)cookieParamName);
            cookieString = cookieString.substring(indexOfIgnoreCase);
        }
        List<HttpCookie> cookies = HttpCookie.parse(cookieString);
        for (HttpCookie httpCookie : cookies) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)httpCookie.getName(), (CharSequence)name)) continue;
            return httpCookie.getValue();
        }
        return null;
    }

    public ResponseUtils(CookieConfigProperties cookieConfigProperties) {
        this.cookieConfigProperties = cookieConfigProperties;
    }
}

