/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.oba;

import de.adorsys.ledgers.middleware.api.domain.oauth.GrantTypeTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthServerInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.OauthRestClient;
import de.adorsys.ledgers.oba.rest.api.resource.oba.ObaOauthApi;
import de.adorsys.ledgers.oba.rest.server.config.security.OauthServerLinkResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oauth"})
public class ObaOauthController
implements ObaOauthApi {
    private static final Logger log = LoggerFactory.getLogger(ObaOauthController.class);
    @Value(value="${oba.url:http://localhost:4400}")
    private String obaFeBaseUri;
    @Value(value="${self.url:http://localhost:8090}")
    private String obaBeBaseUri;
    private final OauthRestClient oauthRestClient;

    public ResponseEntity<OauthCodeResponseTO> oauthCode(String login, String pin, String redirectUri) {
        return this.oauthRestClient.oauthCode(login, pin, redirectUri);
    }

    public ResponseEntity<BearerTokenTO> oauthToken(String code) {
        return this.oauthRestClient.oauthToken(GrantTypeTO.AUTHORISATION_CODE, code);
    }

    public OauthServerInfoTO oauthServerInfo(String redirectId, String paymentId, String consentId, String cancellationId) {
        return new OauthServerLinkResolver((OauthServerInfoTO)this.oauthRestClient.oauthServerInfo().getBody(), paymentId, consentId, cancellationId, redirectId, this.obaBeBaseUri, this.obaFeBaseUri).resolve();
    }

    public ObaOauthController(OauthRestClient oauthRestClient) {
        this.oauthRestClient = oauthRestClient;
    }
}

