/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.exception.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.oba.rest.api.resource.exception.PaymentAuthorizeException;
import de.adorsys.ledgers.oba.rest.server.auth.oba.ErrorResponse;
import de.adorsys.ledgers.oba.rest.server.resource.exception.resolver.AisExceptionStatusResolver;
import de.adorsys.ledgers.oba.rest.server.resource.exception.resolver.AuthorizationExceptionStatusResolver;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PsuMessage;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthorizationException;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import feign.FeignException;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.HandlerMethod;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String DEV_MESSAGE = "devMessage";
    private final ObjectMapper objectMapper;

    @ExceptionHandler(value={ObaException.class})
    public ResponseEntity<Map> handleAisException(ObaException e) {
        HttpStatus status = AisExceptionStatusResolver.resolveHttpStatusByCode(e.getObaErrorCode());
        Map<String, String> message = this.buildContentMap(status.value(), e.getDevMessage());
        return ResponseEntity.status((HttpStatus)status).body(message);
    }

    @ExceptionHandler(value={PaymentAuthorizeException.class})
    public ResponseEntity<Map> handlePaymentAuthorizeException(PaymentAuthorizeException e) {
        PaymentAuthorizeResponse body = (PaymentAuthorizeResponse)e.getError().getBody();
        PsuMessage psuMessage = (PsuMessage)body.getPsuMessages().get(0);
        Map<String, String> content = this.buildContentMap(psuMessage.getCode(), psuMessage.getText());
        return new ResponseEntity(content, HttpStatus.valueOf((int)Integer.parseInt(psuMessage.getCode())));
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ResponseEntity<Map> handleAuthException(AuthorizationException e) {
        HttpStatus status = AuthorizationExceptionStatusResolver.resolveHttpStatusByCode(e.getErrorCode());
        Map<String, String> message = this.buildContentMap(status.value(), e.getDevMessage());
        return ResponseEntity.status((HttpStatus)status).body(message);
    }

    @ExceptionHandler(value={FeignException.class})
    public ResponseEntity<Map> handleFeignException(FeignException ex, HandlerMethod handlerMethod) {
        log.warn("FeignException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        Map<String, String> body = this.buildContentMap(ex.status(), this.resolveErrorMessage(ex));
        return new ResponseEntity(body, HttpStatus.valueOf((int)ex.status()));
    }

    private Map<String, String> buildContentMap(String code, String message) {
        return this.buildContentMap(Integer.parseInt(code), message);
    }

    private Map<String, String> buildContentMap(int code, String message) {
        return new ErrorResponse().buildContent(code, message);
    }

    private String resolveErrorMessage(FeignException ex) {
        try {
            return ex.content() != null ? Optional.ofNullable(this.objectMapper.readTree(ex.content()).get(DEV_MESSAGE)).map(JsonNode::asText).orElseGet(() -> ex.getMessage()) : ex.getMessage();
        }
        catch (IOException e) {
            log.warn("Couldn't read json content");
            return ex.getMessage();
        }
    }

    public GlobalExceptionHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

