/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.ConsentType;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthorizationException;
import de.adorsys.ledgers.oba.service.api.domain.exception.InvalidConsentException;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.WebUtils;

@Service
public class XISControllerService {
    private static final Logger log = LoggerFactory.getLogger(XISControllerService.class);
    private static final String ACCESS_TOKEN_COOKIE = "ACCESS_TOKEN";
    private final AuthRequestInterceptor authInterceptor;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final UserMgmtRestClient userMgmtRestClient;
    private final ConsentReferencePolicy referencePolicy;
    private final ResponseUtils responseUtils;
    @Value(value="${online-banking.sca.loginpage:http://localhost:4400/}")
    private String loginPage;

    public ResponseEntity<AuthorizeResponse> auth(String redirectId, ConsentType consentType, String encryptedConsentId, HttpServletResponse response) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        try {
            ConsentReference consentReference = this.referencePolicy.fromURL(redirectId, consentType, encryptedConsentId);
            authResponse.setEncryptedConsentId(encryptedConsentId);
            authResponse.setAuthorisationId(redirectId);
            String token = Optional.ofNullable(this.request.getHeader("Authorization")).filter(t -> StringUtils.startsWithIgnoreCase((CharSequence)t, (CharSequence)"Bearer ")).map(t -> StringUtils.substringAfter((String)t, (String)"Bearer ")).orElse(null);
            AccessTokenTO tokenTO = Optional.ofNullable(token).map(t -> (BearerTokenTO)this.userMgmtRestClient.validate(t).getBody()).map(BearerTokenTO::getAccessTokenObject).orElse(null);
            this.responseUtils.setCookies(response, consentReference, token, tokenTO);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                response.addHeader("Authorization", token);
            }
        }
        catch (InvalidConsentException e) {
            log.info(e.getMessage());
            this.responseUtils.removeCookies(response);
            return this.responseUtils.unknownCredentials(authResponse, response);
        }
        String uriString = UriComponentsBuilder.fromUriString((String)this.loginPage).queryParam("encryptedConsentId", new Object[]{authResponse.getEncryptedConsentId()}).queryParam("authorisationId", new Object[]{authResponse.getAuthorisationId()}).build().toUriString();
        response.addHeader("Location", uriString);
        return ResponseEntity.ok((Object)authResponse);
    }

    public ResponseEntity<SCALoginResponseTO> performLoginForConsent(String login, String pin, String operationId, String authId, OpTypeTO operationType) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)this.request, (String)ACCESS_TOKEN_COOKIE);
        String token = cookie != null ? cookie.getValue() : null;
        return this.performLoginForConsent(login, pin, token, operationId, authId, operationType);
    }

    private ResponseEntity<SCALoginResponseTO> performLoginForConsent(String login, String pin, String token, String operationId, String authId, OpTypeTO operationType) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.authInterceptor.setAccessToken(token);
            return this.userMgmtRestClient.authoriseForConsent(operationId, authId, operationType);
        }
        if (StringUtils.isNotBlank((CharSequence)login) || StringUtils.isNotBlank((CharSequence)pin)) {
            return this.userMgmtRestClient.authoriseForConsent(login, pin, operationId, authId, operationType);
        }
        throw AuthorizationException.builder().errorCode(AuthErrorCode.LOGIN_FAILED).devMessage("Login or pin is missing.").build();
    }

    public ResponseEntity<PaymentAuthorizeResponse> resolvePaymentWorkflow(PaymentWorkflow workflow) {
        ScaStatusTO scaStatusTO = workflow.scaStatus();
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.FINALISED, ScaStatusTO.EXEMPTED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.SCAMETHODSELECTED).contains(scaStatusTO)) {
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    public XISControllerService(AuthRequestInterceptor authInterceptor, HttpServletRequest request, HttpServletResponse response, UserMgmtRestClient userMgmtRestClient, ConsentReferencePolicy referencePolicy, ResponseUtils responseUtils) {
        this.authInterceptor = authInterceptor;
        this.request = request;
        this.response = response;
        this.userMgmtRestClient = userMgmtRestClient;
        this.referencePolicy = referencePolicy;
        this.responseUtils = responseUtils;
    }
}

