/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.oba;

import de.adorsys.ledgers.oba.rest.api.resource.oba.ObaConsentApi;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.service.api.domain.CreatePiisConsentRequestTO;
import de.adorsys.ledgers.oba.service.api.domain.ObaAisConsent;
import de.adorsys.ledgers.oba.service.api.domain.TppInfoTO;
import de.adorsys.ledgers.oba.service.api.service.ConsentService;
import de.adorsys.ledgers.oba.service.api.service.TppInfoCmsService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/consents"})
public class ObaConsentController
implements ObaConsentApi {
    private static final Logger log = LoggerFactory.getLogger(ObaConsentController.class);
    private final ConsentService consentService;
    private final ObaMiddlewareAuthentication auth;
    private final TppInfoCmsService tppInfoCmsService;

    @PreAuthorize(value="#userLogin == authentication.principal.login")
    public ResponseEntity<List<ObaAisConsent>> consents(String userLogin) {
        return ResponseEntity.ok((Object)this.consentService.getListOfConsents(userLogin));
    }

    public ResponseEntity<Boolean> revokeConsent(String consentId) {
        return ResponseEntity.ok((Object)this.consentService.revokeConsent(consentId));
    }

    public ResponseEntity<Void> confirm(String userLogin, String consentId, String authorizationId, String tan) {
        this.consentService.confirmAisConsentDecoupled(userLogin, consentId, authorizationId, tan);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    public ResponseEntity<Void> createPiis(CreatePiisConsentRequestTO request) {
        this.consentService.createPiisConsent(request, AuthUtils.psuId(this.auth));
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<List<TppInfoTO>> tpps() {
        return ResponseEntity.ok((Object)this.tppInfoCmsService.getTpps());
    }

    public ObaConsentController(ConsentService consentService, ObaMiddlewareAuthentication auth, TppInfoCmsService tppInfoCmsService) {
        this.consentService = consentService;
        this.auth = auth;
        this.tppInfoCmsService = tppInfoCmsService;
    }
}

