/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.config.security;

import de.adorsys.ledgers.middleware.api.domain.oauth.OauthServerInfoTO;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OauthServerLinkResolver {
    private OauthServerInfoTO info;
    private Map<String, String> objectIds = new HashMap<String, String>();
    private Map<String, String> pathPart = new HashMap<String, String>();
    private String redirectId;
    private String requestParameter;
    private String obaFeBaseUri;
    private String obaBeBaseUri;

    public OauthServerLinkResolver(OauthServerInfoTO info, String paymentId, String consentId, String cancellationId, String redirectId, String obaBeBaseUri, String obaFeBaseUri) {
        this.info = info;
        this.objectIds.put("paymentId", paymentId);
        this.objectIds.put("encryptedConsentId", consentId);
        this.objectIds.put("cancellationId", cancellationId);
        this.requestParameter = this.resolvePresentParameter();
        this.pathPart.put("paymentId", "payment-initiation");
        this.pathPart.put("encryptedConsentId", "account-information");
        this.pathPart.put("cancellationId", "payment-cancellation");
        this.redirectId = redirectId;
        this.obaBeBaseUri = obaBeBaseUri;
        this.obaFeBaseUri = obaFeBaseUri;
    }

    public OauthServerInfoTO resolve() {
        String authUri = StringUtils.isNotBlank((CharSequence)this.redirectId) && this.requestParameter != null ? this.resolveParametrizedAuthUri() : this.resolveNonParametrizedAuthUri();
        this.info.setAuthorizationEndpoint(authUri);
        this.info.setTokenEndpoint(this.resolveTokenUri());
        return this.info;
    }

    private String resolveParametrizedAuthUri() {
        return UriComponentsBuilder.fromUriString((String)this.obaFeBaseUri).pathSegment(new String[]{this.pathPart.get(this.requestParameter)}).pathSegment(new String[]{"login"}).queryParam("redirectId", new Object[]{this.redirectId}).queryParam(this.requestParameter, new Object[]{this.objectIds.get(this.requestParameter)}).queryParam("oauth2", new Object[]{true}).build().toUriString();
    }

    private String resolveNonParametrizedAuthUri() {
        return UriComponentsBuilder.fromUriString((String)this.obaFeBaseUri).pathSegment(new String[]{"auth/authorize"}).queryParam("redirect_uri=", new Object[0]).build().toUriString();
    }

    private String resolveTokenUri() {
        return UriComponentsBuilder.fromUriString((String)this.obaBeBaseUri).pathSegment(new String[]{"oauth/token"}).build().toUriString();
    }

    private String resolvePresentParameter() {
        return this.objectIds.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue()))).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public void setInfo(OauthServerInfoTO info) {
        this.info = info;
    }

    public void setObjectIds(Map<String, String> objectIds) {
        this.objectIds = objectIds;
    }

    public void setPathPart(Map<String, String> pathPart) {
        this.pathPart = pathPart;
    }

    public void setRedirectId(String redirectId) {
        this.redirectId = redirectId;
    }

    public void setRequestParameter(String requestParameter) {
        this.requestParameter = requestParameter;
    }

    public void setObaFeBaseUri(String obaFeBaseUri) {
        this.obaFeBaseUri = obaFeBaseUri;
    }

    public void setObaBeBaseUri(String obaBeBaseUri) {
        this.obaBeBaseUri = obaBeBaseUri;
    }
}

