/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.oba;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.oba.rest.api.resource.oba.ObaCancellationApi;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/payment/cancellation"})
public class ObaCancellationController
implements ObaCancellationApi {
    private static final Logger log = LoggerFactory.getLogger(ObaCancellationController.class);
    private final CmsPsuPisService cmsPsuPisService;
    private final PaymentRestClient paymentRestClient;

    public ResponseEntity<SCAPaymentResponseTO> initCancellation(String paymentId) {
        SCAPaymentResponseTO response = (SCAPaymentResponseTO)this.paymentRestClient.initiatePmtCancellation(paymentId).getBody();
        HttpStatus status = this.resolveStatus(paymentId, response);
        return new ResponseEntity((Object)response, status);
    }

    public ResponseEntity<SCAPaymentResponseTO> selectSca(String paymentId, String cancellationId, String scaMethodId) {
        return this.paymentRestClient.selecCancelPaymentSCAtMethod(paymentId, cancellationId, scaMethodId);
    }

    public ResponseEntity<Void> validateTAN(String paymentId, String cancellationId, String authCode) {
        SCAPaymentResponseTO response = (SCAPaymentResponseTO)this.paymentRestClient.authorizeCancelPayment(paymentId, cancellationId, authCode).getBody();
        HttpStatus status = this.resolveStatus(paymentId, response);
        return new ResponseEntity(status);
    }

    private HttpStatus resolveStatus(String paymentId, SCAPaymentResponseTO response) {
        if (EnumSet.of(ScaStatusTO.EXEMPTED, ScaStatusTO.FINALISED).contains(response.getScaStatus())) {
            return this.cmsPsuPisService.updatePaymentStatus(paymentId, TransactionStatus.CANC, "UNDEFINED") ? HttpStatus.NO_CONTENT : HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.OK;
    }

    public ObaCancellationController(CmsPsuPisService cmsPsuPisService, PaymentRestClient paymentRestClient) {
        this.cmsPsuPisService = cmsPsuPisService;
        this.paymentRestClient = paymentRestClient;
    }
}

