/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.exception.resolver;

import de.adorsys.ledgers.oba.service.api.domain.exception.AuthErrorCode;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.http.HttpStatus;

public class AuthorizationExceptionStatusResolver {
    private static final Map<AuthErrorCode, HttpStatus> container = new EnumMap<AuthErrorCode, HttpStatus>(AuthErrorCode.class);

    private AuthorizationExceptionStatusResolver() {
    }

    public static HttpStatus resolveHttpStatusByCode(AuthErrorCode code) {
        return container.get(code);
    }

    static {
        container.put(AuthErrorCode.LOGIN_FAILED, HttpStatus.FORBIDDEN);
        container.put(AuthErrorCode.ACCESS_FORBIDDEN, HttpStatus.FORBIDDEN);
        container.put(AuthErrorCode.AUTHENTICATION_FAILED, HttpStatus.FORBIDDEN);
        container.put(AuthErrorCode.CONSENT_DATA_UPDATE_FAILED, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

