/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.auth.oba;

import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.server.auth.oba.AbstractAuthFilter;
import de.adorsys.ledgers.oba.rest.server.auth.oba.RestException;
import feign.FeignException;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;

public class TokenAuthenticationFilter
extends AbstractAuthFilter {
    private final UserMgmtRestClient ledgersUserMgmt;
    private final AuthRequestInterceptor authInterceptor;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String bearerToken = this.resolveBearerToken(request);
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.authenticationIsRequired()) {
            try {
                this.authInterceptor.setAccessToken(bearerToken);
                ResponseEntity validateResponse = this.ledgersUserMgmt.validate(bearerToken);
                BearerTokenTO token = Optional.ofNullable((BearerTokenTO)validateResponse.getBody()).orElseThrow(() -> new RestException("Couldn't get bearer token"));
                this.fillSecurityContext(token);
            }
            catch (RestException | FeignException e) {
                this.handleAuthenticationFailure(response, (Exception)e);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String resolveBearerToken(HttpServletRequest request) {
        return Optional.ofNullable(this.obtainFromHeader(request, "Authorization")).filter(StringUtils::isNotBlank).filter(t -> StringUtils.startsWithIgnoreCase((CharSequence)t, (CharSequence)"Bearer ")).map(t -> StringUtils.substringAfter((String)t, (String)"Bearer ")).orElse(null);
    }

    public TokenAuthenticationFilter(UserMgmtRestClient ledgersUserMgmt, AuthRequestInterceptor authInterceptor) {
        this.ledgersUserMgmt = ledgersUserMgmt;
        this.authInterceptor = authInterceptor;
    }
}

