/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.auth.oba;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.server.auth.oba.AbstractAuthFilter;
import de.adorsys.ledgers.oba.rest.server.auth.oba.RestException;
import feign.FeignException;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;

public class LoginAuthenticationFilter
extends AbstractAuthFilter {
    private final UserMgmtRestClient userMgmtRestClient;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String login = this.obtainFromHeader(request, "login");
        String pin = this.obtainFromHeader(request, "pin");
        if (StringUtils.isBlank((CharSequence)login) || StringUtils.isBlank((CharSequence)pin)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.authenticationIsRequired()) {
            try {
                ResponseEntity loginResponse = this.userMgmtRestClient.authorise(login, pin, UserRoleTO.CUSTOMER);
                BearerTokenTO bearerTokenTO = Optional.ofNullable((SCALoginResponseTO)loginResponse.getBody()).map(SCAResponseTO::getBearerToken).orElseThrow(() -> new RestException("Couldn't get bearer token"));
                this.fillSecurityContext(bearerTokenTO);
                this.addBearerTokenHeader(bearerTokenTO.getAccess_token(), response);
            }
            catch (RestException | FeignException e) {
                this.handleAuthenticationFailure(response, (Exception)e);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void addBearerTokenHeader(String token, HttpServletResponse response) {
        response.setHeader("access_token", token);
    }

    public LoginAuthenticationFilter(UserMgmtRestClient userMgmtRestClient) {
        this.userMgmtRestClient = userMgmtRestClient;
    }
}

