/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.oba.rest.api.resource.PISApi;
import de.adorsys.ledgers.oba.rest.api.resource.exception.PaymentAuthorizeException;
import de.adorsys.ledgers.oba.rest.server.resource.AbstractXISController;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentType;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pis"})
@Api(value="/pis", tags={"PSU PIS. Provides access to online banking payment functionality"})
public class PISController
extends AbstractXISController
implements PISApi {
    private final CommonPaymentService paymentService;

    public ResponseEntity<AuthorizeResponse> pisAuth(String redirectId, String encryptedPaymentId, String token) {
        return this.auth(redirectId, ConsentType.PIS, encryptedPaymentId, this.response);
    }

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<PaymentAuthorizeResponse> login(String encryptedPaymentId, String authorisationId, String login, String pin, String consentCookieString) {
        String consentCookie = this.responseUtils.consentCookie(consentCookieString);
        PaymentWorkflow workflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, false, consentCookie, login, null);
        ResponseEntity<SCALoginResponseTO> loginResult = this.performLoginForConsent(login, pin, workflow.paymentId(), workflow.authId(), OpTypeTO.PAYMENT);
        AuthUtils.checkIfUserInitiatedOperation(loginResult, workflow.getPaymentResponse().getPayment().getPsuIdDatas());
        workflow.processSCAResponse((SCAResponseTO)Objects.requireNonNull(loginResult.getBody()));
        if (!AuthUtils.success(loginResult)) {
            this.responseUtils.removeCookies(this.response);
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        String psuId = AuthUtils.psuId(workflow.bearerToken());
        PaymentWorkflow initiatePaymentWorkflow = this.paymentService.initiatePayment(workflow, psuId);
        return this.resolvePaymentWorkflow(initiatePaymentWorkflow);
    }

    public ResponseEntity<PaymentAuthorizeResponse> initiatePayment(String encryptedPaymentId, String authorisationId, String consentAndaccessTokenCookieString) {
        try {
            String psuId = AuthUtils.psuId(this.middlewareAuth);
            String consentCookie = this.responseUtils.consentCookie(consentAndaccessTokenCookieString);
            PaymentWorkflow identifyPaymentWorkflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, psuId, this.middlewareAuth.getBearerToken());
            identifyPaymentWorkflow.getScaResponse().setScaStatus(ScaStatusTO.PSUAUTHENTICATED);
            PaymentWorkflow initiatePaymentWorkflow = this.paymentService.initiatePayment(identifyPaymentWorkflow, psuId);
            this.responseUtils.setCookies(this.response, initiatePaymentWorkflow.getConsentReference(), initiatePaymentWorkflow.bearerToken().getAccess_token(), initiatePaymentWorkflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)initiatePaymentWorkflow.getAuthResponse());
        }
        catch (PaymentAuthorizeException e) {
            return e.getError();
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndaccessTokenCookieString) {
        PaymentWorkflow workflow;
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndaccessTokenCookieString);
            workflow = this.paymentService.selectScaForPayment(encryptedPaymentId, authorisationId, scaMethodId, consentCookie, false, AuthUtils.psuId(this.middlewareAuth), this.middlewareAuth.getBearerToken());
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
        }
        catch (PaymentAuthorizeException p) {
            return p.getError();
        }
        return ResponseEntity.ok((Object)workflow.getAuthResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> authrizedPayment(String encryptedPaymentId, String authorisationId, String consentAndaccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(consentAndaccessTokenCookieString);
            PaymentWorkflow identifyPaymentWorkflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, psuId, this.middlewareAuth.getBearerToken());
            PaymentWorkflow authorizePaymentWorkflow = this.paymentService.authorizePayment(identifyPaymentWorkflow, psuId, authCode);
            this.responseUtils.setCookies(this.response, authorizePaymentWorkflow.getConsentReference(), authorizePaymentWorkflow.bearerToken().getAccess_token(), authorizePaymentWorkflow.bearerToken().getAccessTokenObject());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authorizePaymentWorkflow.getAuthResponse());
            return responseEntity;
        }
        catch (PaymentAuthorizeException e) {
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> failPaymentAuthorisation(String encryptedPaymentId, String authorisationId, String cookieString) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        try {
            String consentCookie = this.responseUtils.consentCookie(cookieString);
            PaymentWorkflow workflow = this.paymentService.identifyPayment(encryptedPaymentId, authorisationId, true, consentCookie, psuId, this.middlewareAuth.getBearerToken());
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            workflow.getScaResponse().setScaStatus(ScaStatusTO.FAILED);
            this.paymentService.updateAspspConsentData(workflow);
            this.responseUtils.removeCookies(this.response);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)workflow.getAuthResponse());
            return responseEntity;
        }
        catch (PaymentAuthorizeException e) {
            this.responseUtils.removeCookies(this.response);
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> pisDone(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, Boolean forgetConsent, Boolean backToTpp, boolean isOauth2Integrated) {
        String psuId = AuthUtils.psuId(this.middlewareAuth);
        String consentCookie = this.responseUtils.consentCookie(consentAndAccessTokenCookieString);
        String redirectUrl = this.paymentService.resolveRedirectUrl(encryptedPaymentId, authorisationId, consentCookie, isOauth2Integrated, psuId, this.middlewareAuth.getBearerToken());
        return this.responseUtils.redirect(redirectUrl, this.response);
    }

    @Override
    public String getBasePath() {
        return "/pis";
    }

    public PISController(CommonPaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

