/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.resource.oba;

import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Api(value="/api/v1", tags={"Online Banking Authorization. Provides access to online banking"})
public interface ObaAuthorizationApi {
    public static final String BASE_PATH = "/api/v1";

    @PostMapping(value={"/login"})
    @ApiOperation(value="Perform Online Banking Login")
    public void login(@RequestHeader(value="login") String var1, @RequestHeader(value="pin") String var2);

    @ApiOperation(value="Get current user", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/me"})
    public ResponseEntity<UserTO> getSelf();

    @ApiOperation(value="Send link to update password", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/users/reset/password/{login}"})
    public ResponseEntity<Void> resetPasswordViaEmail(@PathVariable(value="login") String var1);

    @ApiOperation(value="Edit current user", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/me"})
    public ResponseEntity<Void> editSelf(@RequestBody UserTO var1);
}

