/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.resource;

import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="/pis-cancellation", tags={"PSU PIS. Provides access to online banking payment functionality"})
public interface PisCancellationApi {
    public static final String BASE_PATH = "/pis-cancellation";

    @PostMapping(path={"/{encryptedPaymentId}/authorisation/{authorisationId}/login"})
    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<PaymentAuthorizeResponse> login(@PathVariable(value="encryptedPaymentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(value="login", required=false) String var3, @RequestParam(value="pin", required=false) String var4);

    @PostMapping(value={"/{encryptedPaymentId}/authorisation/{authorisationId}/methods/{scaMethodId}"})
    @ApiOperation(value="Selects the SCA Method for use.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<PaymentAuthorizeResponse> selectMethod(@PathVariable(value="encryptedPaymentId") String var1, @PathVariable(value="authorisationId") String var2, @PathVariable(value="scaMethodId") String var3);

    @PostMapping(path={"/{encryptedPaymentId}/authorisation/{authorisationId}/authCode"}, params={"authCode"})
    @ApiOperation(value="Provides a TAN for the validation of an authorization", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<PaymentAuthorizeResponse> authorisePayment(@PathVariable(value="encryptedPaymentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(value="authCode") String var3);

    @GetMapping(path={"/{encryptedPaymentId}/authorisation/{authorisationId}/done"})
    @ApiOperation(value="Close consent session", authorizations={@Authorization(value="apiKey")}, notes="This call provides the server with the opportunity to close this session and redirect the PSU to the TPP or close the application window.")
    public ResponseEntity<PaymentAuthorizeResponse> pisDone(@PathVariable(value="encryptedPaymentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(name="oauth2", required=false, defaultValue="false") boolean var3, @RequestParam(name="authConfirmationCode", required=false) String var4);
}

