/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.resource;

import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="/sca", tags={"PSU SCA. Provides access to one time password for strong customer authentication."})
public interface SCAApi {
    public static final String BASE_PATH = "/sca";

    @PostMapping(value={"/login"})
    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<AuthorizeResponse> login(@RequestParam(value="login") String var1, @RequestParam(value="pin") String var2);

    @PostMapping(path={"/{scaId}/authorisation/{authorisationId}/methods/{methodId}"})
    @ApiOperation(value="Selects the SCA Method for use.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<AuthorizeResponse> selectMethod(@PathVariable(value="scaId") String var1, @PathVariable(value="authorisationId") String var2, @PathVariable(value="methodId") String var3, @RequestHeader(name="Cookie", required=false) String var4);

    @PostMapping(path={"/{scaId}/authorisation/{authorisationId}/authCode"}, params={"authCode"})
    @ApiOperation(value="Validate the provided authentication code.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<AuthorizeResponse> validateAuthCode(@PathVariable(value="scaId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(name="authCode") String var3, @RequestHeader(name="Cookie", required=false) String var4);
}

