/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.CreatePiisConsentRequestTO;
import de.adorsys.ledgers.oba.service.api.domain.PIISConsentCreateResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="/ais", tags={"PSU AIS. Provides access to online banking AIS functionality"})
public interface AISApi {
    public static final String BASE_PATH = "/ais";

    @GetMapping(path={"/auth"}, params={"redirectId", "encryptedConsentId"})
    @ApiOperation(value="Entry point for authenticating ais consent requests.")
    public ResponseEntity<AuthorizeResponse> aisAuth(@RequestParam(name="redirectId") String var1, @RequestParam(name="encryptedConsentId") String var2, @RequestHeader(name="Authorization", required=false) String var3);

    @PostMapping(path={"/{encryptedConsentId}/authorisation/{authorisationId}/login"})
    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<ConsentAuthorizeResponse> login(@PathVariable(value="encryptedConsentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(value="login", required=false) String var3, @RequestParam(value="pin", required=false) String var4, @RequestHeader(name="Cookie", required=false) String var5);

    @PostMapping(value={"/{encryptedConsentId}/authorisation/{authorisationId}/start"})
    @ApiOperation(value="Starts the cosent authaurization process after user selects which account to grant access to", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<ConsentAuthorizeResponse> startConsentAuth(@PathVariable(value="encryptedConsentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestHeader(name="Cookie", required=false) String var3, @RequestBody AisConsentTO var4);

    @PostMapping(value={"/{encryptedConsentId}/authorisation/{authorisationId}/methods/{scaMethodId}"})
    @ApiOperation(value="Selects the SCA Method for use.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<ConsentAuthorizeResponse> selectMethod(@PathVariable(value="encryptedConsentId") String var1, @PathVariable(value="authorisationId") String var2, @PathVariable(value="scaMethodId") String var3, @RequestHeader(name="Cookie", required=false) String var4);

    @PostMapping(path={"/{encryptedConsentId}/authorisation/{authorisationId}/authCode"}, params={"authCode"})
    @ApiOperation(value="Provides a TAN for the validation of an authorization", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<ConsentAuthorizeResponse> authrizedConsent(@PathVariable(value="encryptedConsentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestHeader(name="Cookie", required=false) String var3, @RequestParam(value="authCode") String var4);

    @PostMapping(path={"/piis"})
    @ApiOperation(value="Grant a piis consent", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<PIISConsentCreateResponse> grantPiisConsent(@RequestHeader(name="Cookie", required=false) String var1, @RequestBody CreatePiisConsentRequestTO var2);

    @GetMapping(path={"/accounts"})
    @ApiOperation(value="List fo Accessible Accounts", authorizations={@Authorization(value="apiKey")}, notes="Returns the list of all accounts linked to the connected user. Call only available to role CUSTOMER.")
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO[].class, message="List of accounts accessible to the user.")})
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts(@RequestHeader(name="Cookie", required=false) String var1);

    @GetMapping(path={"/{encryptedConsentId}/authorisation/{authorisationId}/done"})
    @ApiOperation(value="Close consent session", authorizations={@Authorization(value="apiKey")}, notes="This call provides the server with the opportunity to close this session and redirect the PSU to the TPP or close the application window.")
    public ResponseEntity<ConsentAuthorizeResponse> aisDone(@PathVariable(value="encryptedConsentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestHeader(name="Cookie", required=false) String var3, @RequestParam(name="oauth2", required=false, defaultValue="false") boolean var4, @RequestParam(name="authConfirmationCode", required=false) String var5);

    @DeleteMapping(path={"/{encryptedConsentId}/{authorisationId}"})
    @ApiOperation(value="Revoke consent", authorizations={@Authorization(value="apiKey")}, notes="This call provides the server with the opportunity to close this session and revoke consent.")
    public ResponseEntity<ConsentAuthorizeResponse> revokeConsent(@PathVariable(value="encryptedConsentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestHeader(name="Cookie", required=false) String var3);
}

