/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.resource.oba;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.time.LocalDate;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="/api/v1/ais", tags={"Online Banking Account Information"})
public interface ObaAisApi {
    public static final String BASE_PATH = "/api/v1/ais";
    public static final String LOCAL_DATE_YYYY_MM_DD_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TO_QUERY_PARAM = "dateTo";
    public static final String DATE_FROM_QUERY_PARAM = "dateFrom";

    @GetMapping(path={"/accounts/{userLogin}"})
    @ApiOperation(value="Get List of users accounts", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<List<AccountDetailsTO>> accounts(@PathVariable(value="userLogin") String var1);

    @GetMapping(path={"/account/{accountId}"})
    @ApiOperation(value="Get account details by account id", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<AccountDetailsTO> account(@PathVariable(name="accountId") String var1);

    @GetMapping(path={"/transactions/{accountId}"})
    @ApiOperation(value="Get List of transactions for queried account per dates selected", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<List<TransactionTO>> transactions(@PathVariable(name="accountId") String var1, @RequestParam(name="dateFrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var2, @RequestParam(name="dateTo", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var3);
}

