/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.domain;

import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.oba.rest.api.domain.AuthorizeResponse;

public class PaymentAuthorizeResponse
extends AuthorizeResponse {
    private final SinglePaymentTO singlePayment;
    private final BulkPaymentTO bulkPayment;
    private final PeriodicPaymentTO periodicPayment;
    private String authMessageTemplate;

    public PaymentAuthorizeResponse() {
        this.singlePayment = null;
        this.bulkPayment = null;
        this.periodicPayment = null;
    }

    public PaymentAuthorizeResponse(SinglePaymentTO singlePayment) {
        this.singlePayment = singlePayment;
        this.bulkPayment = null;
        this.periodicPayment = null;
    }

    public PaymentAuthorizeResponse(BulkPaymentTO bulkPayment) {
        this.singlePayment = null;
        this.bulkPayment = bulkPayment;
        this.periodicPayment = null;
    }

    public PaymentAuthorizeResponse(PeriodicPaymentTO periodicPayment) {
        this.singlePayment = null;
        this.bulkPayment = null;
        this.periodicPayment = periodicPayment;
    }

    public PaymentAuthorizeResponse(PaymentTypeTO paymentType, Object payment) {
        switch (paymentType) {
            case SINGLE: {
                this.singlePayment = (SinglePaymentTO)payment;
                this.bulkPayment = null;
                this.periodicPayment = null;
                break;
            }
            case BULK: {
                this.singlePayment = null;
                this.bulkPayment = (BulkPaymentTO)payment;
                this.periodicPayment = null;
                break;
            }
            default: {
                this.singlePayment = null;
                this.bulkPayment = null;
                this.periodicPayment = (PeriodicPaymentTO)payment;
            }
        }
    }

    public SinglePaymentTO getSinglePayment() {
        return this.singlePayment;
    }

    public BulkPaymentTO getBulkPayment() {
        return this.bulkPayment;
    }

    public PeriodicPaymentTO getPeriodicPayment() {
        return this.periodicPayment;
    }

    public String getAuthMessageTemplate() {
        return this.authMessageTemplate;
    }

    public void setAuthMessageTemplate(String authMessageTemplate) {
        this.authMessageTemplate = authMessageTemplate;
    }

    public void updatePaymentStatus(TransactionStatusTO paymentStatus) {
        if (this.singlePayment != null) {
            this.singlePayment.setPaymentStatus(paymentStatus);
        } else if (this.bulkPayment != null) {
            this.bulkPayment.setPaymentStatus(paymentStatus);
        } else if (this.periodicPayment != null) {
            this.periodicPayment.setPaymentStatus(paymentStatus);
        }
    }
}

