/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.domain;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReference;
import de.adorsys.ledgers.oba.rest.api.domain.ConsentAuthorizeResponse;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;

public class ConsentWorkflow {
    private final CmsAisConsentResponse consentResponse;
    private String consentStatus;
    private String authCodeMessage;
    private HttpStatus errorCode;
    private ConsentAuthorizeResponse authResponse;
    private final ConsentReference consentReference;
    private SCAResponseTO scaResponse;

    public ConsentWorkflow(@NotNull CmsAisConsentResponse consentResponse, ConsentReference consentReference) {
        if (consentResponse == null || consentReference == null) {
            throw new IllegalStateException("Do not allow null input.");
        }
        this.consentResponse = consentResponse;
        this.consentReference = consentReference;
    }

    public String getAuthCodeMessage() {
        return this.authCodeMessage;
    }

    public void setAuthCodeMessage(String authCodeMessage) {
        this.authCodeMessage = authCodeMessage;
    }

    public HttpStatus getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(HttpStatus errorCode) {
        this.errorCode = errorCode;
    }

    public ConsentAuthorizeResponse getAuthResponse() {
        return this.authResponse;
    }

    public void setAuthResponse(ConsentAuthorizeResponse authResponse) {
        this.authResponse = authResponse;
    }

    public ConsentReference getConsentReference() {
        return this.consentReference;
    }

    public String getConsentStatus() {
        return this.consentStatus;
    }

    public void setConsentStatus(String consentStatus) {
        this.consentStatus = consentStatus;
    }

    public CmsAisConsentResponse getConsentResponse() {
        return this.consentResponse;
    }

    public String consentId() {
        return this.consentResponse.getAccountConsent().getId();
    }

    public String authId() {
        return this.consentResponse.getAuthorisationId();
    }

    public String encryptedConsentId() {
        return this.consentReference.getEncryptedConsentId();
    }

    public SCAResponseTO getScaResponse() {
        return this.scaResponse;
    }

    public void setScaResponse(SCAResponseTO scaResponse) {
        this.scaResponse = scaResponse;
    }

    public BearerTokenTO bearerToken() {
        return this.scaResponse == null ? null : this.scaResponse.getBearerToken();
    }

    public boolean singleScaMethod() {
        return this.scaResponse.getScaMethods() != null && this.scaResponse.getScaMethods().size() == 1;
    }

    public List<ScaUserDataTO> scaMethods() {
        return this.scaResponse.getScaMethods();
    }

    public ScaStatusTO scaStatus() {
        return this.scaResponse.getScaStatus();
    }
}

