/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.api.domain;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReference;
import de.adorsys.ledgers.oba.rest.api.domain.PaymentAuthorizeResponse;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;

public class PaymentWorkflow {
    private final CmsPaymentResponse paymentResponse;
    private String paymentStatus;
    private String authCodeMessage;
    private HttpStatus errorCode;
    private PaymentAuthorizeResponse authResponse;
    private final ConsentReference consentReference;
    private SCAResponseTO scaResponse;

    public PaymentWorkflow(@NotNull CmsPaymentResponse paymentResponse, ConsentReference consentReference) {
        if (paymentResponse == null || consentReference == null) {
            throw new IllegalStateException("Do not allow null input.");
        }
        this.paymentResponse = paymentResponse;
        this.consentReference = consentReference;
    }

    public CmsPaymentResponse getPaymentResponse() {
        return this.paymentResponse;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getAuthCodeMessage() {
        return this.authCodeMessage;
    }

    public void setAuthCodeMessage(String authCodeMessage) {
        this.authCodeMessage = authCodeMessage;
    }

    public HttpStatus getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(HttpStatus errorCode) {
        this.errorCode = errorCode;
    }

    public PaymentAuthorizeResponse getAuthResponse() {
        return this.authResponse;
    }

    public void setAuthResponse(PaymentAuthorizeResponse authResponse) {
        this.authResponse = authResponse;
    }

    public ConsentReference getConsentReference() {
        return this.consentReference;
    }

    public String paymentId() {
        return this.paymentResponse.getPayment().getPaymentId();
    }

    public String authId() {
        return this.paymentResponse.getAuthorisationId();
    }

    public String encryptedConsentId() {
        return this.consentReference.getEncryptedConsentId();
    }

    public SCAResponseTO getScaResponse() {
        return this.scaResponse;
    }

    public void setScaResponse(SCAResponseTO scaResponse) {
        this.scaResponse = scaResponse;
    }

    public BearerTokenTO bearerToken() {
        return this.scaResponse == null ? null : this.scaResponse.getBearerToken();
    }

    public PaymentTypeTO paymentType() {
        return PaymentTypeTO.valueOf((String)this.paymentResponse.getPayment().getPaymentType().name());
    }

    public boolean singleScaMethod() {
        return this.scaResponse.getScaMethods() != null && this.scaResponse.getScaMethods().size() == 1;
    }

    public List<ScaUserDataTO> scaMethods() {
        return this.scaResponse.getScaMethods();
    }

    public ScaStatusTO scaStatus() {
        return this.scaResponse.getScaStatus();
    }
}

