/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.certificate.service;

import de.adorsys.psd2.sandbox.certificate.exception.CertificateException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.springframework.stereotype.Component;

@Component
public class PrivateKeyProvider {
    public PrivateKey getKeyFromClassPath(String filename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream("certificates/" + filename);
        if (stream == null) {
            throw new CertificateException("Could not read private key from classpath:certificates/" + filename);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser pp = new PEMParser((Reader)br);
            PEMKeyPair pemKeyPair = (PEMKeyPair)pp.readObject();
            KeyPair kp = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
            pp.close();
            return kp.getPrivate();
        }
        catch (IOException ex) {
            throw new CertificateException("Could not read private key from classpath", (Throwable)ex);
        }
    }
}

