/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.certificate.service;

import de.adorsys.psd2.sandbox.certificate.exception.CertificateException;
import de.adorsys.psd2.sandbox.certificate.model.CertificateRequest;
import de.adorsys.psd2.sandbox.certificate.model.CertificateResponse;
import de.adorsys.psd2.sandbox.certificate.model.IssuerData;
import de.adorsys.psd2.sandbox.certificate.model.NcaId;
import de.adorsys.psd2.sandbox.certificate.model.NcaName;
import de.adorsys.psd2.sandbox.certificate.model.SubjectData;
import de.adorsys.psd2.sandbox.certificate.service.CertificateService;
import de.adorsys.psd2.sandbox.certificate.service.ExportUtil;
import de.adorsys.psd2.sandbox.certificate.service.IssuerDataService;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CertificateService {
    private static final Logger log = LoggerFactory.getLogger(CertificateService.class);
    private static final String NCA_SHORT_NAME = "FAKENCA";
    private static final ASN1ObjectIdentifier ETSI_QC_STATEMENT = new ASN1ObjectIdentifier("0.4.0.19495.2");
    private static final Random random = new Random();
    private final IssuerDataService issuerDataService;

    public CertificateResponse newCertificate(CertificateRequest certificateRequest) {
        SubjectData subjectData = this.generateSubjectData(certificateRequest);
        QCStatement qcStatement = this.generateQcStatement(certificateRequest);
        X509Certificate cert = this.generateCertificate(subjectData, qcStatement);
        return CertificateResponse.builder().privateKey(ExportUtil.exportToString((Object)subjectData.getPrivateKey())).encodedCert(ExportUtil.exportToString((Object)cert)).build();
    }

    private X509Certificate generateCertificate(SubjectData subjectData, QCStatement statement) {
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder("SHA256WithRSAEncryption");
        IssuerData issuerData = this.issuerDataService.getIssuerData();
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(issuerData.getX500name(), new BigInteger(subjectData.getSerialNumber().toString()), subjectData.getStartDate(), subjectData.getEndDate(), subjectData.getX500name(), subjectData.getPublicKey());
        try {
            ContentSigner contentSigner = builder.build(issuerData.getPrivateKey());
            certGen.addExtension(Extension.qCStatements, false, (ASN1Encodable)statement);
            X509CertificateHolder certHolder = certGen.build(contentSigner);
            JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
            return certConverter.getCertificate(certHolder);
        }
        catch (Exception ex) {
            throw new CertificateException("Could not create certificate", (Throwable)ex);
        }
    }

    private QCStatement generateQcStatement(CertificateRequest certificateRequest) {
        NcaName ncaName = this.getNcaNameFromIssuerData();
        NcaId ncaId = this.getNcaIdFromIssuerData();
        DERSequence qcStatementInfo = this.createQcInfo(RolesOfPsp.fromCertificateRequest((CertificateRequest)certificateRequest), ncaName, ncaId);
        return new QCStatement(ETSI_QC_STATEMENT, (ASN1Encodable)qcStatementInfo);
    }

    private DERSequence createQcInfo(RolesOfPsp rolesOfPsp, NcaName ncaName, NcaId ncaId) {
        return new DERSequence(new ASN1Encodable[]{rolesOfPsp, ncaName, ncaId});
    }

    private NcaName getNcaNameFromIssuerData() {
        return new NcaName(IETFUtils.valueToString((ASN1Encodable)this.issuerDataService.getIssuerData().getX500name().getRDNs(BCStyle.O)[0].getFirst().getValue()));
    }

    private NcaId getNcaIdFromIssuerData() {
        String country = IETFUtils.valueToString((ASN1Encodable)this.issuerDataService.getIssuerData().getX500name().getRDNs(BCStyle.C)[0].getFirst().getValue());
        return new NcaId(country + "-FAKENCA");
    }

    private SubjectData generateSubjectData(CertificateRequest cerData) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.O, cerData.getOrganizationName());
        if (StringUtils.isNotBlank((CharSequence)cerData.getCommonName())) {
            builder.addRDN(BCStyle.CN, cerData.getCommonName());
        }
        if (cerData.getDomainComponent() != null) {
            builder.addRDN(BCStyle.DC, cerData.getDomainComponent());
        }
        if (cerData.getOrganizationUnit() != null) {
            builder.addRDN(BCStyle.OU, cerData.getOrganizationUnit());
        }
        if (cerData.getCountryName() != null) {
            builder.addRDN(BCStyle.C, cerData.getCountryName());
        }
        if (cerData.getStateOrProvinceName() != null) {
            builder.addRDN(BCStyle.ST, cerData.getStateOrProvinceName());
        }
        if (cerData.getLocalityName() != null) {
            builder.addRDN(BCStyle.L, cerData.getLocalityName());
        }
        builder.addRDN(BCStyle.ORGANIZATION_IDENTIFIER, "PSD" + this.getNcaIdFromIssuerData() + "-" + cerData.getAuthorizationNumber());
        Date expiration = Date.from(LocalDate.now().plusDays(cerData.getValidity()).atStartOfDay(ZoneOffset.UTC).toInstant());
        KeyPair keyPairSubject = this.generateKeyPair();
        Integer serialNumber = random.nextInt(Integer.MAX_VALUE);
        return new SubjectData(keyPairSubject.getPrivate(), keyPairSubject.getPublic(), builder.build(), serialNumber, new Date(), expiration);
    }

    private KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048, SecureRandom.getInstance("SHA1PRNG", "SUN"));
            return keyGen.generateKeyPair();
        }
        catch (GeneralSecurityException ex) {
            throw new CertificateException("Could not generate key pair", (Throwable)ex);
        }
    }

    public CertificateService(IssuerDataService issuerDataService) {
        this.issuerDataService = issuerDataService;
    }
}

