/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.certificate.service;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.sandbox.certificate.exception.CertificateException;
import de.adorsys.psd2.sandbox.certificate.model.IssuerData;
import de.adorsys.psd2.sandbox.certificate.service.PrivateKeyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IssuerDataService {
    private static final Logger log = LoggerFactory.getLogger(IssuerDataService.class);
    private static final String ISSUER_PRIVATE_KEY = "MyRootCA.key";
    private static final String ISSUER_CERTIFICATE = "MyRootCA.pem";
    private IssuerData issuerData;
    private final PrivateKeyProvider privateKeyProvider;

    public IssuerDataService(PrivateKeyProvider privateKeyProvider) {
        this.privateKeyProvider = privateKeyProvider;
        this.issuerData = this.generateIssuerData();
    }

    public IssuerData getIssuerData() {
        return this.issuerData;
    }

    public X509Certificate getCertificateFromClassPath() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream("certificates/MyRootCA.pem");
        if (is == null) {
            throw new CertificateException("Could not find certificate in classpath");
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            return X509CertUtils.parse((byte[])bytes);
        }
        catch (IOException ex) {
            throw new CertificateException("Could not read certificate from classpath", (Throwable)ex);
        }
    }

    private IssuerData generateIssuerData() {
        IssuerData data = new IssuerData();
        X509Certificate cert = this.getCertificateFromClassPath();
        log.debug("Source for issuer data: {} from {}", (Object)cert, (Object)ISSUER_CERTIFICATE);
        try {
            data.setX500name(new JcaX509CertificateHolder(cert).getSubject());
        }
        catch (CertificateEncodingException ex) {
            throw new CertificateException("Could not read issuer data from certificate", (Throwable)ex);
        }
        data.setPrivateKey(this.privateKeyProvider.getKeyFromClassPath(ISSUER_PRIVATE_KEY));
        return data;
    }
}

