/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.certificate.exception;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import de.adorsys.psd2.sandbox.certificate.exception.CertificateException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice(basePackages={"de.adorsys.psd2.sandbox.certificate.controller"})
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String MESSAGE = "message";
    private static final String CODE = "code";
    private static final String DATE_TIME = "dateTime";

    @ExceptionHandler(value={InvalidFormatException.class})
    public ResponseEntity<Map<String, String>> handleInvalidFormatException(InvalidFormatException e, HandlerMethod handlerMethod) {
        log.warn("Invalid format exception handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)this.getHandlerContent("Invalid initial data"));
    }

    @ExceptionHandler(value={CertificateException.class})
    public ResponseEntity<Map<String, String>> handleCertificateException(CertificateException e, HandlerMethod handlerMethod) {
        log.warn("Invalid format exception handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)this.getHandlerContent(e.getMessage()));
    }

    private Map<String, String> getHandlerContent(String message) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put(CODE, String.valueOf(HttpStatus.BAD_REQUEST.value()));
        error.put(MESSAGE, message);
        error.put(DATE_TIME, LocalDateTime.now().toString());
        return error;
    }
}

