/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.certificate.util;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.validator.certificate.CertificateErrorMsgCode;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import de.adorsys.psd2.validator.common.PSD2QCStatement;
import de.adorsys.psd2.validator.common.PSD2QCType;
import de.adorsys.psd2.validator.common.RoleOfPSP;
import de.adorsys.psd2.validator.common.RolesOfPSP;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import no.difi.certvalidator.api.CertificateValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExtractorUtil {
    private static final Logger log = LoggerFactory.getLogger(CertificateExtractorUtil.class);
    private static final String LDAP_COMMON_NAME = "CN";

    private CertificateExtractorUtil() {
    }

    public static TppCertificateData extract(String encodedCert) throws CertificateValidationException {
        RoleOfPSP[] roles2;
        X509Certificate cert = X509CertUtils.parse((String)encodedCert);
        if (cert == null) {
            log.debug("Error reading certificate ");
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        ArrayList<String> roles = new ArrayList<String>();
        TppCertificateData tppCertData = new TppCertificateData();
        PSD2QCType psd2qcType = PSD2QCStatement.psd2QCType(cert);
        RolesOfPSP rolesOfPSP = psd2qcType.getRolesOfPSP();
        for (RoleOfPSP roleOfPSP : roles2 = rolesOfPSP.getRoles()) {
            roles.add(roleOfPSP.getNormalizedRoleName());
        }
        tppCertData.setPspRoles(roles);
        tppCertData.setPspAuthorityName(psd2qcType.getnCAName().getString());
        tppCertData.setPspAuthorityId(psd2qcType.getnCAId().getString());
        tppCertData.setIssuerCN(CertificateExtractorUtil.extractIssuerCNFromIssuerDN(cert.getIssuerDN()));
        tppCertData.setNotAfter(cert.getNotAfter());
        try {
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            tppCertData.setPspAuthorisationNumber(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.ORGANIZATION_IDENTIFIER));
            tppCertData.setOrganisation(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.O));
            tppCertData.setOrganisationUnit(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.OU));
            tppCertData.setCity(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.L));
            tppCertData.setState(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.ST));
            tppCertData.setCountry(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.C));
            tppCertData.setName(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.CN));
        }
        catch (CertificateEncodingException e) {
            log.debug(e.getMessage());
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        tppCertData.setDnsList(CertificateExtractorUtil.getSubjectAltNames(cert, 2));
        return tppCertData;
    }

    private static String getValueFromX500Name(X500Name x500Name, ASN1ObjectIdentifier asn1ObjectIdentifier) {
        boolean exist = ArrayUtils.contains((Object[])x500Name.getAttributeTypes(), (Object)asn1ObjectIdentifier);
        return exist ? IETFUtils.valueToString((ASN1Encodable)x500Name.getRDNs(asn1ObjectIdentifier)[0].getFirst().getValue()) : null;
    }

    private static String extractIssuerCNFromIssuerDN(Principal issuerDN) {
        List<Rdn> rdns = CertificateExtractorUtil.getRdns(issuerDN);
        return rdns.stream().filter(rdn -> LDAP_COMMON_NAME.equalsIgnoreCase(rdn.getType())).findFirst().filter(rdn -> rdn.getValue() instanceof String).map(rdn -> (String)rdn.getValue()).orElse(null);
    }

    private static List<Rdn> getRdns(Principal issuerDN) {
        return Optional.ofNullable(issuerDN).map(Principal::getName).map(CertificateExtractorUtil::getLdapName).map(LdapName::getRdns).orElseGet(Collections::emptyList);
    }

    private static LdapName getLdapName(String dn) {
        try {
            return new LdapName(dn);
        }
        catch (InvalidNameException e) {
            log.error("Error extracting issuer cn from dn: {}", (Object)dn);
            return null;
        }
    }

    private static List<String> getSubjectAltNames(X509Certificate certificate, int type) {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (CollectionUtils.isEmpty(subjectAltNames)) {
                return Collections.emptyList();
            }
            return certificate.getSubjectAlternativeNames().stream().map(entry -> entry).filter(CertificateExtractorUtil::isValidSubjectAltName).filter(e -> (Integer)e.get(0) == type).map(e -> (String)e.get(1)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (CertificateParsingException e2) {
            return Collections.emptyList();
        }
    }

    private static boolean isValidSubjectAltName(List<?> entry) {
        return entry != null && entry.size() >= 2 && entry.get(0) != null;
    }
}

