/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.signature;

import de.adorsys.psd2.validator.signature.Verify;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.Mac;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.Base64;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public class Symmetric
implements Verify {
    private final Key key;
    private final Algorithm algorithm;
    private final Provider provider;
    private final Signature signature;

    Symmetric(Key key, Provider provider, Algorithm algorithm, Signature signature) {
        this.key = key;
        this.provider = provider;
        this.algorithm = algorithm;
        this.signature = signature;
    }

    @Override
    public boolean verify(byte[] signingStringBytes) {
        try {
            Mac mac = this.provider == null ? Mac.getInstance(this.algorithm.getJmvName()) : Mac.getInstance(this.algorithm.getJmvName(), this.provider);
            mac.init(this.key);
            byte[] hash = mac.doFinal(signingStringBytes);
            byte[] encoded = Base64.encodeBase64((byte[])hash);
            return Arrays.equals(encoded, this.signature.getSignature().getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedAlgorithmException(this.algorithm.getJmvName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

