/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.signature;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.validator.signature.SignatureVerifier;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tomitribe.auth.signatures.Signature;

public class TppSignatureValidator {
    private static final List<String> MANDATORY_HEADERS_PSD2 = Arrays.asList("digest", "tpp-transaction-id", "x-request-id", "timestamp");

    public boolean verifySignature(String signature, String tppEncodedCert, Map<String, String> headers) throws IOException {
        if (StringUtils.isBlank((CharSequence)signature)) {
            throw new IllegalArgumentException("SIGNATURE_MISSING");
        }
        if (StringUtils.isBlank((CharSequence)tppEncodedCert)) {
            throw new IllegalArgumentException("CERTIFICAT_MISSING");
        }
        Signature signatureData = Signature.fromString((String)signature);
        if (!signatureData.getHeaders().containsAll(MANDATORY_HEADERS_PSD2)) {
            throw new IllegalArgumentException("SIGNATURE_INVALID");
        }
        X509Certificate cert = X509CertUtils.parse((String)tppEncodedCert);
        PublicKey key = cert.getPublicKey();
        SignatureVerifier verifier = new SignatureVerifier(key, signatureData);
        return verifier.verify("method", "uri", headers);
    }
}

