/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.common;

import de.adorsys.psd2.validator.common.RoleOfPSP;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;

public class RolesOfPSP {
    private final RoleOfPSP[] roles;
    private final DERSequence sequence;

    public RolesOfPSP(RoleOfPSP ... roles) {
        this.roles = (RoleOfPSP[])roles.clone();
        this.sequence = new DERSequence((ASN1Encodable[])Arrays.stream(roles).map(RoleOfPSP::toDERSequence).toArray(ASN1Encodable[]::new));
    }

    public static RolesOfPSP getInstance(Object obj) {
        if (obj instanceof RolesOfPSP) {
            return (RolesOfPSP)obj;
        }
        ASN1Encodable[] array = DERSequence.getInstance((Object)obj).toArray();
        RoleOfPSP[] roles = (RoleOfPSP[])Arrays.stream(array).map(RoleOfPSP::getInstance).toArray(RoleOfPSP[]::new);
        return new RolesOfPSP(roles);
    }

    public DERSequence toDERSequence() {
        return this.sequence;
    }

    public RoleOfPSP[] getRoles() {
        return (RoleOfPSP[])this.roles.clone();
    }
}

