/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.signature;

import de.adorsys.psd2.validator.signature.Asymmetric;
import de.adorsys.psd2.validator.signature.Symmetric;
import de.adorsys.psd2.validator.signature.Verify;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.Signatures;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public class SignatureVerifier {
    private final Verify verify;
    private final org.tomitribe.auth.signatures.Signature signature;

    public SignatureVerifier(Key key, org.tomitribe.auth.signatures.Signature signature) {
        this(key, signature, null);
    }

    public SignatureVerifier(Key key, org.tomitribe.auth.signatures.Signature signature, Provider provider) {
        Objects.requireNonNull(key, "Key cannot be null");
        this.signature = Objects.requireNonNull(signature, "Signature cannot be null");
        Algorithm algorithm = signature.getAlgorithm();
        if (Signature.class.equals((Object)algorithm.getType())) {
            this.verify = new Asymmetric((PublicKey)PublicKey.class.cast(key), provider, algorithm, signature);
        } else if (Mac.class.equals((Object)algorithm.getType())) {
            this.verify = new Symmetric(key, provider, algorithm, signature);
        } else {
            throw new UnsupportedAlgorithmException(String.format("Unknown Algorithm type %s %s", algorithm.getPortableName(), algorithm.getType().getName()));
        }
        try {
            this.verify.verify("validation".getBytes());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't initialise the Signer using the provided algorithm and key", e);
        }
    }

    public boolean verify(String method, String uri, Map<String, String> headers) throws IOException {
        String signingString = this.createSigningString(method, uri, headers);
        return this.verify.verify(signingString.getBytes());
    }

    public String createSigningString(String method, String uri, Map<String, String> headers) throws IOException {
        return Signatures.createSigningString((List)this.signature.getHeaders(), (String)method, (String)uri, headers);
    }
}

