/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.certificate.util;

import com.nimbusds.jose.util.X509CertUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final Logger log = LoggerFactory.getLogger(CertificateUtils.class);

    public static X509Certificate[] getCertificates(String folderName, String ... fileNames) {
        return (X509Certificate[])Arrays.stream(fileNames).map(fileName -> CertificateUtils.getCertificate(folderName + "/" + fileName)).toArray(X509Certificate[]::new);
    }

    private static X509Certificate getCertificate(String filePath) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            byte[] bytes = IOUtils.resourceToByteArray((String)filePath, (ClassLoader)loader);
            return X509CertUtils.parse((byte[])bytes);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static String getCertificateByName(String filename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            byte[] bytes = IOUtils.resourceToByteArray((String)("certificates/" + filename), (ClassLoader)loader);
            X509Certificate cert = X509CertUtils.parse((byte[])bytes);
            return X509CertUtils.toPEMString((X509Certificate)cert);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            return null;
        }
    }
}

