/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.signature;

import de.adorsys.psd2.validator.signature.Verify;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.Base64;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public class Asymmetric
implements Verify {
    private final PublicKey key;
    private final Algorithm algorithm;
    private final Provider provider;
    private final org.tomitribe.auth.signatures.Signature signature;

    Asymmetric(PublicKey key, Provider provider, Algorithm algorithm, org.tomitribe.auth.signatures.Signature signature) {
        this.key = key;
        this.provider = provider;
        this.algorithm = algorithm;
        this.signature = signature;
    }

    @Override
    public boolean verify(byte[] signingStringBytes) {
        try {
            Signature instance = this.provider == null ? Signature.getInstance(this.algorithm.getJmvName()) : Signature.getInstance(this.algorithm.getJmvName(), this.provider);
            instance.initVerify(this.key);
            instance.update(signingStringBytes);
            return instance.verify(Base64.decodeBase64((byte[])this.signature.getSignature().getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedAlgorithmException(this.algorithm.getJmvName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

