/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.certificate;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.validator.certificate.BlackListRule;
import de.adorsys.psd2.validator.certificate.CRLRuleExt;
import de.adorsys.psd2.validator.certificate.CertificateErrorMsgCode;
import de.adorsys.psd2.validator.certificate.ChainRuleExt;
import de.adorsys.psd2.validator.certificate.ExpirationRuleExt;
import de.adorsys.psd2.validator.certificate.FailedCertValidationException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import no.difi.certvalidator.Validator;
import no.difi.certvalidator.ValidatorBuilder;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.ValidatorRule;
import no.difi.certvalidator.util.SimpleCertificateBucket;
import org.apache.commons.lang3.StringUtils;

public class CertificateValidatorFactory {
    private Validator validator;

    public CertificateValidatorFactory(SimpleCertificateBucket blockedCertBucket, SimpleCertificateBucket rootCertificates, SimpleCertificateBucket intermediateCertificates) {
        this.validator = ValidatorBuilder.newInstance().addRule((ValidatorRule)new ExpirationRuleExt()).addRule((ValidatorRule)new CRLRuleExt()).addRule((ValidatorRule)new BlackListRule((CertificateBucket)blockedCertBucket)).addRule((ValidatorRule)new ChainRuleExt((CertificateBucket)rootCertificates, (CertificateBucket)intermediateCertificates)).build();
    }

    public boolean validate(String encodedCert) throws CertificateException, CertificateValidationException {
        if (StringUtils.isBlank((CharSequence)encodedCert)) {
            throw new FailedCertValidationException(CertificateErrorMsgCode.CERTIFICATE_MISSING.name(), CertificateErrorMsgCode.CERTIFICATE_MISSING.toString());
        }
        X509Certificate cert = X509CertUtils.parse((String)encodedCert);
        if (cert == null) {
            throw new FailedCertValidationException(CertificateErrorMsgCode.CERTIFICATE_MISSING.name(), CertificateErrorMsgCode.CERTIFICATE_MISSING.toString());
        }
        this.validator.validate(cert);
        return true;
    }
}

