/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.common;

import de.adorsys.psd2.validator.common.NCAId;
import de.adorsys.psd2.validator.common.NCAName;
import de.adorsys.psd2.validator.common.RolesOfPSP;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class PSD2QCType {
    private final RolesOfPSP rolesOfPSP;
    private final NCAName nCAName;
    private final NCAId nCAId;

    public PSD2QCType(RolesOfPSP rolesOfPSP, NCAName nCAName, NCAId nCAId) {
        this.rolesOfPSP = rolesOfPSP;
        this.nCAName = nCAName;
        this.nCAId = nCAId;
    }

    public static PSD2QCType getInstance(ASN1Encodable asn1Encodable) {
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)asn1Encodable);
        RolesOfPSP rolesOfPSP = RolesOfPSP.getInstance(sequence.getObjectAt(0));
        NCAName nCAName = NCAName.getInstance(sequence.getObjectAt(1));
        NCAId nCAId = NCAId.getInstance(sequence.getObjectAt(2));
        return new PSD2QCType(rolesOfPSP, nCAName, nCAId);
    }

    public DERSequence toDERSequence() {
        return new DERSequence(new ASN1Encodable[]{this.rolesOfPSP.toDERSequence(), this.nCAName, this.nCAId});
    }

    public RolesOfPSP getRolesOfPSP() {
        return this.rolesOfPSP;
    }

    public NCAName getnCAName() {
        return this.nCAName;
    }

    public NCAId getnCAId() {
        return this.nCAId;
    }
}

