/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.certificate.util;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.validator.certificate.CertificateErrorMsgCode;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import de.adorsys.psd2.validator.common.PSD2QCStatement;
import de.adorsys.psd2.validator.common.PSD2QCType;
import de.adorsys.psd2.validator.common.RoleOfPSP;
import de.adorsys.psd2.validator.common.RolesOfPSP;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import no.difi.certvalidator.api.CertificateValidationException;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExtractorUtil {
    private static final Logger log = LoggerFactory.getLogger(CertificateExtractorUtil.class);

    private CertificateExtractorUtil() {
    }

    public static TppCertificateData extract(String encodedCert) throws CertificateValidationException {
        RoleOfPSP[] roles2;
        X509Certificate cert = X509CertUtils.parse((String)encodedCert);
        if (cert == null) {
            log.debug("Error reading certificate ");
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        ArrayList<String> roles = new ArrayList<String>();
        TppCertificateData tppCertData = new TppCertificateData();
        PSD2QCType psd2qcType = PSD2QCStatement.psd2QCType(cert);
        RolesOfPSP rolesOfPSP = psd2qcType.getRolesOfPSP();
        for (RoleOfPSP roleOfPSP : roles2 = rolesOfPSP.getRoles()) {
            roles.add(roleOfPSP.getNormalizedRoleName());
        }
        tppCertData.setPspRoles(roles);
        tppCertData.setPspAuthorityName(psd2qcType.getnCAName().getString());
        tppCertData.setPspAuthorityId(psd2qcType.getnCAId().getString());
        try {
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            tppCertData.setPspAuthorisationNumber(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.ORGANIZATION_IDENTIFIER));
            tppCertData.setOrganisation(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.O));
            tppCertData.setOrganisationUnit(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.OU));
            tppCertData.setCity(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.L));
            tppCertData.setState(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.ST));
            tppCertData.setCountry(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.C));
            tppCertData.setName(CertificateExtractorUtil.getValueFromX500Name(x500name, BCStyle.CN));
        }
        catch (CertificateEncodingException e) {
            log.debug(e.getMessage());
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        return tppCertData;
    }

    private static String getValueFromX500Name(X500Name x500Name, ASN1ObjectIdentifier asn1ObjectIdentifier) {
        boolean exist = ArrayUtils.contains((Object[])x500Name.getAttributeTypes(), (Object)asn1ObjectIdentifier);
        return exist ? IETFUtils.valueToString((ASN1Encodable)x500Name.getRDNs(asn1ObjectIdentifier)[0].getFirst().getValue()) : null;
    }
}

