/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.certificate.util;

import com.nimbusds.jose.util.X509CertUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final Logger log = LoggerFactory.getLogger(CertificateUtils.class);
    private static final int CERTIFICATE_PART_DATA_SIZE = 64;
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----\n";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    private CertificateUtils() {
    }

    public static X509Certificate[] getCertificates(String folderName, String ... fileNames) {
        return (X509Certificate[])Arrays.stream(fileNames).map(fileName -> CertificateUtils.getCertificate(folderName + "/" + fileName)).toArray(X509Certificate[]::new);
    }

    private static X509Certificate getCertificate(String filePath) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            byte[] bytes = IOUtils.resourceToByteArray((String)filePath, (ClassLoader)loader);
            return X509CertUtils.parse((byte[])bytes);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static String getCertificateByName(String filename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            byte[] bytes = IOUtils.resourceToByteArray((String)("certificates/" + filename), (ClassLoader)loader);
            X509Certificate cert = X509CertUtils.parse((byte[])bytes);
            return X509CertUtils.toPEMString((X509Certificate)cert);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static String normalizeCertificate(String certificate) {
        if (certificate == null) {
            return null;
        }
        String certificateData = CertificateUtils.getCertificateData(certificate);
        return BEGIN_CERTIFICATE + certificateData.replaceAll(".{64}", "$0\n") + END_CERTIFICATE;
    }

    private static String getCertificateData(String certificate) {
        return certificate.replace(" ", "").replace("\n", "").replace("-----BEGINCERTIFICATE-----", "").replace("-----ENDCERTIFICATE-----", "");
    }
}

