/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.signature.service.algorithm;

import de.adorsys.psd2.validator.signature.service.algorithm.hashing.HashingService;
import de.adorsys.psd2.validator.signature.service.algorithm.hashing.Sha256HashingService;
import de.adorsys.psd2.validator.signature.service.algorithm.hashing.Sha512HashingService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum HashingAlgorithm {
    SHA256("SHA-256", new Sha256HashingService()),
    SHA512("SHA-512", new Sha512HashingService());

    private String algorithmName;
    private HashingService hashingService;
    private static final Map<String, HashingAlgorithm> CONTAINER;

    private HashingAlgorithm(String algorithmName, HashingService hashingService) {
        this.algorithmName = algorithmName;
        this.hashingService = hashingService;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public HashingService getHashingService() {
        return this.hashingService;
    }

    public static Optional<HashingAlgorithm> fromValue(String text) {
        if (text != null) {
            return Optional.ofNullable(CONTAINER.get(text.trim()));
        }
        return Optional.empty();
    }

    static {
        CONTAINER = new HashMap<String, HashingAlgorithm>();
        for (HashingAlgorithm algorithm : HashingAlgorithm.values()) {
            CONTAINER.put(algorithm.getAlgorithmName(), algorithm);
        }
    }
}

