/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.signature.impl;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.validator.certificate.util.CertificateUtils;
import de.adorsys.psd2.validator.signature.SignatureVerifier;
import de.adorsys.psd2.validator.signature.service.RequestHeaders;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Verifier;

public class SignatureVerifierImpl
implements SignatureVerifier {
    private static final Logger log = LoggerFactory.getLogger(SignatureVerifierImpl.class);

    @Override
    public boolean verify(String signature, String tppEncodedCert, Map<String, String> headers, String method, String url) {
        X509Certificate certificate = X509CertUtils.parse((String)CertificateUtils.normalizeCertificate(tppEncodedCert));
        if (certificate == null) {
            log.warn("TPP Certificate couldn't be parsed!");
            return false;
        }
        Signature signatureData = Signature.fromString((String)signature);
        if (!this.isKeyIdValid(certificate, signatureData.getKeyId())) {
            log.warn("Key ID is invalid!");
            return false;
        }
        Map<String, String> headersMap = RequestHeaders.fromMap(headers).toMap();
        try {
            Verifier verifier = new Verifier((Key)certificate.getPublicKey(), signatureData);
            return verifier.verify(method, url, headersMap);
        }
        catch (Exception e) {
            log.warn("Signature verification has an error: {}", (Object)e.getMessage());
            return false;
        }
    }

    private boolean isKeyIdValid(X509Certificate certificate, String keyId) {
        return StringUtils.equals((CharSequence)keyId, (CharSequence)this.getKeyIdFromCertificate(certificate));
    }

    private String getKeyIdFromCertificate(X509Certificate certificate) {
        return "SN=" + certificate.getSerialNumber().toString(16) + ",CA=" + certificate.getIssuerX500Principal().getName().replace(" ", "%20").replace("\n", "");
    }
}

