/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.signature.impl;

import de.adorsys.psd2.validator.signature.DigestVerifier;
import de.adorsys.psd2.validator.signature.service.Digest;
import de.adorsys.psd2.validator.signature.service.algorithm.HashingAlgorithm;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DigestVerifierImpl
implements DigestVerifier {
    @Override
    public boolean verify(String digestFromRequest, String body) {
        if (StringUtils.isBlank((CharSequence)digestFromRequest)) {
            return false;
        }
        return this.handleHashAlgorithm(digestFromRequest).map(alg -> this.buildDigest(body, (HashingAlgorithm)((Object)alg))).map(dg -> digestFromRequest.equals(dg.getHeaderValue())).orElse(false);
    }

    private Digest buildDigest(String requestBody, HashingAlgorithm algorithm) {
        return Digest.builder().requestBody(requestBody).hashingAlgorithm(algorithm).build();
    }

    private Optional<HashingAlgorithm> handleHashAlgorithm(String digestFromRequest) {
        String[] digestContent = digestFromRequest.split("=");
        if (digestContent.length < 2) {
            return Optional.empty();
        }
        return HashingAlgorithm.fromValue(digestContent[0]);
    }
}

