/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.common;

import de.adorsys.psd2.validator.certificate.CertificateErrorMsgCode;
import de.adorsys.psd2.validator.common.PSD2QCType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Optional;
import no.difi.certvalidator.api.CertificateValidationException;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSD2QCStatement {
    private static final Logger log = LoggerFactory.getLogger(PSD2QCStatement.class);
    private static final ASN1ObjectIdentifier idEtsiPsd2QcStatement = new ASN1ObjectIdentifier("0.4.0.19495.2");

    private PSD2QCStatement() {
    }

    public static QCStatement psd2QCStatement() {
        return new QCStatement(idEtsiPsd2QcStatement);
    }

    public static PSD2QCType psd2QCType(X509Certificate cert) throws CertificateValidationException {
        byte[] extValues = cert.getExtensionValue(Extension.qCStatements.getId());
        if (extValues == null) {
            log.debug("QCStatement not found in psd2 certificate. Missing extension with value {}", (Object)Extension.qCStatements.getId());
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        QCStatement qcStatement = PSD2QCStatement.readQCStatement(extValues);
        ASN1Encodable statementInfo = qcStatement.getStatementInfo();
        return PSD2QCType.getInstance(statementInfo);
    }

    private static QCStatement readQCStatement(byte[] extensionValue) throws CertificateValidationException {
        ASN1Sequence qcStatements;
        try (ASN1InputStream derAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(extensionValue));){
            DEROctetString oct = (DEROctetString)derAsn1InputStream.readObject();
            try (ASN1InputStream asn1InputStream = new ASN1InputStream(oct.getOctets());){
                qcStatements = (ASN1Sequence)asn1InputStream.readObject();
            }
        }
        catch (IOException e) {
            log.debug("Error reading qcstatement " + e);
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        if (qcStatements.size() <= 0) {
            log.debug("No ETSI PSD2 QcStatement in psd2 certificate");
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        ASN1Encodable object = qcStatements.getObjectAt(0);
        if (object.toASN1Primitive() instanceof ASN1ObjectIdentifier) {
            return PSD2QCStatement.getSingleQcStatement(qcStatements);
        }
        return PSD2QCStatement.getEtsiPsd2QcStatement(qcStatements).orElseThrow(() -> new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString()));
    }

    private static Optional<QCStatement> getEtsiPsd2QcStatement(ASN1Sequence qcStatements) {
        FilterIterator filteredIterator = new FilterIterator(qcStatements.iterator(), item -> {
            QCStatement qcStatement = QCStatement.getInstance((Object)item);
            return qcStatement.getStatementId().getId().equals(idEtsiPsd2QcStatement.getId());
        });
        if (!filteredIterator.hasNext()) {
            log.debug("No ETSI PSD2 QcStatement in psd2 certificate");
            return Optional.empty();
        }
        return Optional.of(QCStatement.getInstance((Object)filteredIterator.next()));
    }

    private static QCStatement getSingleQcStatement(ASN1Sequence qcStatements) throws CertificateValidationException {
        QCStatement qcStatement = QCStatement.getInstance((Object)qcStatements);
        if (!idEtsiPsd2QcStatement.getId().equals(qcStatement.getStatementId().getId())) {
            log.debug("Wrong statement type in psd2 certificate. expected is {} but found {}", (Object)idEtsiPsd2QcStatement.getId(), (Object)qcStatement.getStatementId().getId());
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        return qcStatement;
    }
}

