/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.reader;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.xs2a.reader.ParseContentJsonReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class JsonReader {
    private Xs2aObjectMapper xs2aObjectMapper;

    public JsonReader() {
        this.xs2aObjectMapper = this.getObjectMapper();
    }

    public JsonReader(Map<String, Boolean> properties) {
        this.xs2aObjectMapper = new Xs2aObjectMapper();
        this.xs2aObjectMapper.findAndRegisterModules();
        for (Map.Entry<String, Boolean> property : properties.entrySet()) {
            this.xs2aObjectMapper.configure(SerializationFeature.valueOf((String)property.getKey()), property.getValue().booleanValue());
        }
    }

    public <T> T getObjectFromFile(String fileName, Class<T> name) {
        URL resourcePath = this.getFileFromClasspath(fileName);
        try {
            return (T)this.xs2aObjectMapper.readValue(resourcePath, name);
        }
        catch (IOException e) {
            throw new ParseContentJsonReaderException("Exception during class '" + name + "' parsing. " + e.getMessage());
        }
    }

    public <T> T getObjectFromFile(String fileName, TypeReference<T> name) {
        URL resourcePath = this.getFileFromClasspath(fileName);
        try {
            return (T)this.xs2aObjectMapper.readValue(resourcePath, name);
        }
        catch (IOException e) {
            throw new ParseContentJsonReaderException("Exception during class '" + name + "' parsing. " + e.getMessage());
        }
    }

    public String getStringFromFile(String fileName) {
        try {
            return IOUtils.toString((InputStream)this.getResourceAsStream(fileName), (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new ParseContentJsonReaderException("Exception during reading '" + fileName + "' file.");
        }
    }

    public byte[] getBytesFromFile(String fileName) {
        try {
            return IOUtils.toByteArray((InputStream)this.getResourceAsStream(fileName));
        }
        catch (Exception e) {
            throw new ParseContentJsonReaderException("Exception during reading '" + fileName + "' file.");
        }
    }

    public <T> T getObjectFromString(String json, Class<T> name) {
        try {
            return (T)this.xs2aObjectMapper.readValue(json, name);
        }
        catch (IOException e) {
            throw new ParseContentJsonReaderException("Exception during class '" + name + "' parsing. " + e.getMessage());
        }
    }

    public <T> List<T> getListFromString(String json, Class<T> name) {
        try {
            return (List)this.xs2aObjectMapper.readValue(json, (JavaType)this.xs2aObjectMapper.getTypeFactory().constructCollectionType(List.class, name));
        }
        catch (IOException e) {
            throw new ParseContentJsonReaderException("Exception during list of class '" + name + "' parsing. " + e.getMessage());
        }
    }

    public <T> List<T> getListFromFile(String fileName, Class<T> name) {
        URL resourcePath = this.getFileFromClasspath(fileName);
        try {
            return (List)this.xs2aObjectMapper.readValue(resourcePath, (JavaType)this.xs2aObjectMapper.getTypeFactory().constructCollectionType(List.class, name));
        }
        catch (IOException e) {
            throw new ParseContentJsonReaderException("Exception during list of class '" + name + "' parsing. " + e.getMessage());
        }
    }

    public String writeValueAsString(Object value) {
        try {
            return this.xs2aObjectMapper.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new ParseContentJsonReaderException("Exception during object parsing to String." + e.getMessage());
        }
    }

    private URL getFileFromClasspath(String filename) {
        return JsonReader.class.getClassLoader().getResource(filename);
    }

    private InputStream getResourceAsStream(String resourcePath) {
        return JsonReader.class.getClassLoader().getResourceAsStream(resourcePath);
    }

    private Xs2aObjectMapper getObjectMapper() {
        Xs2aObjectMapper xs2aObjectMapper = new Xs2aObjectMapper();
        xs2aObjectMapper.findAndRegisterModules();
        xs2aObjectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return xs2aObjectMapper;
    }
}

