/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.integtest.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDateDeserializer<T>
extends StdDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(CustomDateDeserializer.class);
    private final Class<T> vc;

    public CustomDateDeserializer(Class<T> vc) {
        super(vc);
        this.vc = vc;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            Method now = Optional.ofNullable(this.vc.getMethod("now", new Class[0])).orElseThrow(() -> new IllegalArgumentException("Can't find method now"));
            return (T)now.invoke(this.vc.getDeclaredClasses(), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Can't invoke method 'now'");
            return null;
        }
    }
}

