/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.integtest.config.rest;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class AspspProfileRestConfig {
    @Value(value="${aspspProfile.config.readTimeoutInMs}")
    private int readTimeout;
    @Value(value="${aspspProfile.config.connectionTimeoutInMs}")
    private int connectionTimeout;
    @Value(value="${aspspProfile.baseUrl}")
    private String aspspProfileBaseUrl;

    @Bean(name={"aspspProfileBaseUrl"})
    public String aspspProfileBaseUrl() {
        return this.aspspProfileBaseUrl;
    }

    @Bean(name={"aspspProfileRestTemplate"})
    @Qualifier(value="aspsp-profile")
    public RestTemplate aspspProfileRestTemplate() {
        RestTemplate rest = new RestTemplate(this.clientHttpRequestFactory());
        rest.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        rest.getMessageConverters().add(new StringHttpMessageConverter());
        return rest;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.connectionTimeout);
        return factory;
    }
}

