/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.event.service.mapper;

import de.adorsys.psd2.event.persist.model.EventPO;
import de.adorsys.psd2.event.service.model.EventBO;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import java.io.IOException;
import java.util.UUID;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class Xs2aEventBOMapper {
    private static final Logger log = LoggerFactory.getLogger(Xs2aEventBOMapper.class);
    @Autowired
    protected Xs2aObjectMapper xs2aObjectMapper;

    @Mappings(value={@Mapping(target="XRequestId", source="XRequestId", qualifiedByName={"mapToXRequestId"}), @Mapping(target="internalRequestId", source="internalRequestId", qualifiedByName={"mapToInternalRequestId"}), @Mapping(target="payload", qualifiedByName={"mapToBytes"})})
    public abstract EventPO toEventPO(EventBO var1);

    protected byte[] mapToBytes(Object object) {
        try {
            return this.xs2aObjectMapper.writeValueAsBytes(object);
        }
        catch (IOException e) {
            log.info("Can't convert json to object: {}", (Object)e.getMessage());
            return new byte[0];
        }
    }

    @Named(value="mapToXRequestId")
    protected String mapToXRequestId(UUID xRequestId) {
        return xRequestId != null ? xRequestId.toString() : null;
    }

    @Named(value="mapToInternalRequestId")
    protected String mapToInternalRequestId(UUID internalRequestId) {
        return internalRequestId != null ? internalRequestId.toString() : null;
    }
}

