/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.event.persist.mapper;

import de.adorsys.psd2.event.persist.entity.EventEntity;
import de.adorsys.psd2.event.persist.entity.PsuDataEmbeddable;
import de.adorsys.psd2.event.persist.mapper.EventDBMapper;
import de.adorsys.psd2.event.persist.model.EventPO;
import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import java.util.Arrays;
import org.springframework.stereotype.Component;

@Component
public class EventDBMapperImpl
implements EventDBMapper {
    @Override
    public EventEntity toEventEntity(EventPO eventPO) {
        if (eventPO == null) {
            return null;
        }
        EventEntity eventEntity = new EventEntity();
        eventEntity.setPsuData(this.psuIdDataPOToPsuDataEmbeddable(eventPO.getPsuIdData()));
        eventEntity.setId(eventPO.getId());
        eventEntity.setTimestamp(eventPO.getTimestamp());
        eventEntity.setConsentId(eventPO.getConsentId());
        eventEntity.setPaymentId(eventPO.getPaymentId());
        byte[] payload = eventPO.getPayload();
        if (payload != null) {
            eventEntity.setPayload(Arrays.copyOf(payload, payload.length));
        }
        eventEntity.setEventOrigin(eventPO.getEventOrigin());
        eventEntity.setEventType(eventPO.getEventType());
        eventEntity.setTppAuthorisationNumber(eventPO.getTppAuthorisationNumber());
        eventEntity.setXRequestId(eventPO.getXRequestId());
        if (eventPO.getInstanceId() != null) {
            eventEntity.setInstanceId(eventPO.getInstanceId());
        } else {
            eventEntity.setInstanceId("UNDEFINED");
        }
        eventEntity.setInternalRequestId(eventPO.getInternalRequestId());
        return eventEntity;
    }

    protected PsuDataEmbeddable psuIdDataPOToPsuDataEmbeddable(PsuIdDataPO psuIdDataPO) {
        if (psuIdDataPO == null) {
            return null;
        }
        PsuDataEmbeddable psuDataEmbeddable = new PsuDataEmbeddable();
        psuDataEmbeddable.setPsuId(psuIdDataPO.getPsuId());
        psuDataEmbeddable.setPsuIdType(psuIdDataPO.getPsuIdType());
        psuDataEmbeddable.setPsuCorporateId(psuIdDataPO.getPsuCorporateId());
        psuDataEmbeddable.setPsuCorporateIdType(psuIdDataPO.getPsuCorporateIdType());
        return psuDataEmbeddable;
    }
}

